/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.DataRowExpressionEvaluatorAdapter;
import org.eclipse.birt.chart.factory.IGroupedDataRowExpressionEvaluator;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;

public class BIRTCubeResultSetEvaluator
extends DataRowExpressionEvaluatorAdapter
implements IGroupedDataRowExpressionEvaluator {
    protected static final ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    protected ICubeResultSet rs;
    protected ICubeQueryResults qr;
    protected ICubeCursor cubeCursor;
    protected long lSizeLimit = Long.MAX_VALUE;
    protected EdgeCursor mainEdgeCursor;
    protected EdgeCursor subEdgeCursor;
    protected List<Integer> lstBreaks = new ArrayList<Integer>();
    protected int iIndex = 0;
    protected boolean bWithoutSub = false;

    public BIRTCubeResultSetEvaluator(ICubeResultSet rs) {
        this.rs = rs;
        this.qr = null;
    }

    public BIRTCubeResultSetEvaluator(ICubeQueryResults qr) throws BirtException {
        this.rs = null;
        this.qr = qr;
        try {
            this.initCubeCursor();
        }
        catch (OLAPException e) {
            logger.log((Exception)((Object)e));
        }
    }

    public int[] getGroupBreaks(int groupLevel) {
        if (this.lstBreaks.size() <= 1) {
            if (this.bWithoutSub && this.iIndex > 0) {
                int[] breaks = new int[this.iIndex - 1];
                int i = 0;
                while (i < breaks.length) {
                    breaks[i] = i + 1;
                    ++i;
                }
                return breaks;
            }
            return new int[0];
        }
        int[] breaks = new int[this.lstBreaks.size() - 1];
        int i = 0;
        while (i < breaks.length) {
            breaks[i] = this.lstBreaks.get(i);
            ++i;
        }
        return breaks;
    }

    public Object evaluate(String expression) {
        Object result = null;
        try {
            this.exprCodec.decode(expression);
            if (this.rs != null) {
                result = this.rs.evaluate(this.exprCodec.getType(), this.exprCodec.getExpression());
            } else {
                String bindingName = this.exprCodec.isCubeBinding(false) ? this.exprCodec.getCubeBindingName(false) : ChartUtil.escapeSpecialCharacters((String)this.exprCodec.getExpression());
                result = this.cubeCursor.getObject(bindingName);
            }
        }
        catch (OLAPException e) {
            result = e;
        }
        catch (BirtException e) {
            result = e;
        }
        catch (RuntimeException e) {
            logger.log((Exception)e);
            result = e;
        }
        return result;
    }

    public Object evaluateGlobal(String expression) {
        return this.evaluate(expression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean next() {
        block3: {
            ++this.iIndex;
            try {
                if (this.subEdgeCursor == null) return this.hasNext(this.mainEdgeCursor);
                if (!this.hasNext(this.subEdgeCursor)) break block3;
                return true;
            }
            catch (OLAPException e) {
                logger.log((Exception)((Object)e));
                return false;
            }
        }
        this.lstBreaks.add(this.iIndex);
        this.subEdgeCursor.first();
        return this.hasNext(this.mainEdgeCursor);
    }

    protected boolean hasNext(EdgeCursor cursor) throws OLAPException {
        return cursor.next() && cursor.getPosition() < this.lSizeLimit;
    }

    public void close() {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.qr != null) {
            try {
                this.qr.close();
            }
            catch (BirtException e) {
                logger.log((Exception)((Object)e));
            }
        }
    }

    public boolean first() {
        try {
            this.initCubeCursor();
            if (this.mainEdgeCursor.first()) {
                if (this.subEdgeCursor != null) {
                    this.subEdgeCursor.first();
                } else {
                    this.bWithoutSub = true;
                }
                return true;
            }
        }
        catch (OLAPException e) {
            logger.log((Exception)((Object)e));
        }
        catch (BirtException e) {
            logger.log((Exception)((Object)e));
        }
        return false;
    }

    protected void initCubeCursor() throws OLAPException, BirtException {
        if (this.cubeCursor == null) {
            this.cubeCursor = this.getCubeCursor();
            this.initCursors();
        }
    }

    protected void initCursors() throws OLAPException, ChartException {
        List edges = this.cubeCursor.getOrdinateEdge();
        if (edges.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.reportitem", 19, Messages.getString("exception.no.cube.edge"));
        }
        if (edges.size() == 1) {
            this.mainEdgeCursor = (EdgeCursor)edges.get(0);
            this.subEdgeCursor = null;
        } else {
            this.mainEdgeCursor = (EdgeCursor)edges.get(0);
            this.subEdgeCursor = (EdgeCursor)edges.get(1);
        }
    }

    protected ICubeCursor getCubeCursor() throws BirtException {
        if (this.rs != null) {
            return (ICubeCursor)this.rs.getCubeCursor();
        }
        return this.qr.getCubeCursor();
    }

    public boolean needCategoryGrouping() {
        return false;
    }

    public boolean needOptionalGrouping() {
        return false;
    }

    public void setSizeLimit(long dataSize) {
        this.lSizeLimit = dataSize;
    }
}

