/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl.rank;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrException;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.aggregation.impl.rank.PercentileAccumulator;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalPercentile
extends AggrFunction {
    public String getName() {
        return "PERCENTILE";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 3;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, ""), new ParameterDefn("percentage", Messages.getString("TotalPercentile.param.percentage"), false, false, SupportedDataTypes.CALCULATABLE, "")};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    public String getDescription() {
        return Messages.getString("TotalPercentile.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalPercentile.displayName");
    }

    private static class MyAccumulator
    extends PercentileAccumulator {
        private MyAccumulator() {
        }

        protected double getPctValue(Double d) throws DataException {
            if (d == null) {
                throw DataException.wrap((BirtException)new AggrException("aggregation.InvalidPercentileArgument"));
            }
            double pct = d;
            if (pct < 0.0 || pct > 1.0) {
                throw DataException.wrap((BirtException)new AggrException("aggregation.InvalidPercentileArgument"));
            }
            return pct;
        }
    }
}

