/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;
import org.eclipse.birt.data.engine.impl.OdaDataSetRuntime;
import org.eclipse.birt.data.engine.impl.PreparedOdaDSQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.odi.IQuery;

public class PreparedIncreCacheDSQuery
extends PreparedOdaDSQuery
implements IPreparedQuery {
    PreparedIncreCacheDSQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        super(dataEngine, queryDefn, dataSetDesign, appContext, null);
    }

    protected QueryExecutor newExecutor() throws DataException {
        IIncreCacheDataSetDesign icDataSetDesign = (IIncreCacheDataSetDesign)this.dataSetDesign;
        String cacheDir = CacheUtil.createIncrementalTempDir(this.dataEngine.getSession(), icDataSetDesign);
        logger.log(Level.INFO, "Create incremental cache directory: " + cacheDir);
        return new IncreCacheDSQueryExecutor(cacheDir);
    }

    public class IncreCacheDSQueryExecutor
    extends PreparedOdaDSQuery.OdaDSQueryExecutor {
        private String cacheDir;

        public IncreCacheDSQueryExecutor(String cacheDir) {
            super(PreparedIncreCacheDSQuery.this);
            this.cacheDir = cacheDir;
        }

        protected IQuery createOdiQuery() throws DataException {
            OdaDataSetRuntime extDataSet = (OdaDataSetRuntime)this.dataSet;
            assert (extDataSet != null);
            assert (this.odiDataSource != null);
            IIncreCacheDataSetDesign icDataSetDesign = (IIncreCacheDataSetDesign)PreparedIncreCacheDSQuery.this.dataSetDesign;
            String queryText = null;
            try {
                long lasttime = CacheUtil.getLastTimestamp(this.cacheDir);
                queryText = icDataSetDesign.getQueryForUpdate(lasttime);
            }
            catch (DataException dataException) {
                File dataFile = new File(this.cacheDir, "data.data");
                if (FileSecurity.fileExist(dataFile)) {
                    FileSecurity.fileDelete(dataFile);
                    logger.log(Level.WARNING, "Incremental cache data file was deleted! path: " + FileSecurity.fileGetAbsolutePath(dataFile));
                }
                queryText = icDataSetDesign.getQueryText();
            }
            String dataSetType = extDataSet.getExtensionID();
            logger.log(Level.INFO, "Execute SQL: " + queryText);
            this.odiQuery = this.odiDataSource.newQuery(dataSetType, queryText, false, this.contextVisitor);
            return this.odiQuery;
        }
    }
}

