/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher.views;

import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.graysky.eclipse.logwatcher.LogwatcherPlugin;
import org.graysky.eclipse.logwatcher.actions.ClearDisplayAction;
import org.graysky.eclipse.logwatcher.actions.CloseWatcherAction;
import org.graysky.eclipse.logwatcher.actions.CopyAction;
import org.graysky.eclipse.logwatcher.actions.EditWatcherAction;
import org.graysky.eclipse.logwatcher.actions.FindAction;
import org.graysky.eclipse.logwatcher.actions.NewWatcherAction;
import org.graysky.eclipse.logwatcher.actions.ToggleScrollingAction;
import org.graysky.eclipse.logwatcher.filters.Filter;
import org.graysky.eclipse.logwatcher.views.WatcherData;
import org.graysky.eclipse.logwatcher.watchers.TextFileWatcher;
import org.graysky.eclipse.logwatcher.watchers.WatcherLoader;
import org.graysky.eclipse.logwatcher.watchers.WatcherUpdateListener;
import org.graysky.eclipse.util.BoundedList;
import org.graysky.eclipse.util.XmlUtils;
import org.w3c.dom.Element;

public class LogWatcherView
extends ViewPart {
    private Action m_closeAction = null;
    private Action m_newAction = null;
    private Action m_clearAction = null;
    private Action m_findAction = null;
    private Action m_scrollAction = null;
    private Action m_editAction = null;
    private CTabFolder m_folder = null;
    private Action m_copyAction = null;
    private Vector m_watchers = new Vector();
    private static final String WATCHER_STATE_FILENAME = "watcherState.xml";
    private IPropertyChangeListener m_propListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("logwatcherFont")) {
                LogwatcherPlugin plugin = LogwatcherPlugin.getDefault();
                plugin.putFont("logwatcherFont", PreferenceConverter.getFontDataArray((IPreferenceStore)plugin.getPreferenceStore(), (String)"logwatcherFont"));
                Iterator iter = LogWatcherView.this.m_watchers.iterator();
                while (iter.hasNext()) {
                    WatcherData entry = (WatcherData)iter.next();
                    entry.getViewer().getTextWidget().setFont(plugin.getFont("logwatcherFont"));
                }
            }
        }
    };

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        LogwatcherPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.m_propListener);
    }

    public void createPartControl(Composite parent) {
        this.m_folder = new CTabFolder(parent, 0);
        this.m_folder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = (CTabItem)e.item;
                LogWatcherView.this.setViewTitle(item.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CTabItem item = (CTabItem)e.item;
                LogWatcherView.this.setViewTitle(item.getText());
            }
        });
        this.makeActions();
        this.contributeToActionBars();
        this.setGlobalActionHandlers();
        this.loadWatcherState();
    }

    private void loadWatcherState() {
        if (LogwatcherPlugin.getDefault().getPreferenceStore().getBoolean("saveWatchers")) {
            WatcherLoader loader = new WatcherLoader(this);
            IPath path = LogwatcherPlugin.getDefault().getStateLocation();
            path = path.addTrailingSeparator();
            path = path.append(WATCHER_STATE_FILENAME);
            try {
                loader.loadWatchers(new FileReader(path.toFile()));
            }
            catch (Exception e) {
                LogwatcherPlugin.getDefault().logError("Error loading watcher state", e);
            }
        }
    }

    private void setGlobalActionHandlers() {
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.m_findAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.m_copyAction);
    }

    private void setViewTitle(String name) {
        String title = "LogWatcher";
        if (name != null) {
            title = String.valueOf(title) + " - " + name;
        }
        this.setContentDescription(title);
        this.setPartName(title);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.m_newAction);
        manager.add((IContributionItem)new Separator("new"));
        manager.add((IAction)this.m_copyAction);
        manager.add((IAction)this.m_findAction);
        manager.add((IAction)this.m_clearAction);
        manager.add((IContributionItem)new Separator("other"));
        manager.add((IAction)this.m_editAction);
        manager.add((IAction)this.m_scrollAction);
        manager.add((IAction)this.m_closeAction);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.m_newAction);
        manager.add((IAction)this.m_editAction);
        manager.add((IAction)this.m_clearAction);
        manager.add((IAction)this.m_scrollAction);
        manager.add((IAction)this.m_closeAction);
    }

    public void closeSelectedWatcher() {
        WatcherData entry = this.getSelectedEntry();
        if (entry != null) {
            entry.dispose();
            this.m_watchers.remove(entry);
            if (this.m_folder.getItemCount() == 0) {
                this.setViewTitle(null);
                this.m_closeAction.setEnabled(false);
                this.m_clearAction.setEnabled(false);
                this.m_scrollAction.setEnabled(false);
                this.m_editAction.setEnabled(false);
            }
            this.saveWatcherState();
        }
    }

    private void makeActions() {
        this.m_closeAction = new CloseWatcherAction(this);
        this.m_closeAction.setEnabled(false);
        this.m_newAction = new NewWatcherAction(this);
        this.m_editAction = new EditWatcherAction(this);
        this.m_editAction.setEnabled(false);
        this.m_clearAction = new ClearDisplayAction(this);
        this.m_clearAction.setEnabled(false);
        this.m_findAction = new FindAction(this);
        this.m_copyAction = new CopyAction(this);
        this.m_scrollAction = new ToggleScrollingAction(this);
        this.m_scrollAction.setChecked(false);
        this.m_scrollAction.setEnabled(false);
    }

    public void addWatcher(File file, int interval, int numLines, Vector filters, boolean saveState) {
        TextFileWatcher watcher;
        CTabItem newItem = new CTabItem(this.m_folder, 0);
        newItem.setToolTipText(file.getAbsolutePath());
        newItem.setText(file.getName());
        this.setViewTitle(file.getName());
        this.m_folder.setSelection(newItem);
        TextViewer viewer = new TextViewer((Composite)this.m_folder, 768);
        newItem.setControl(viewer.getControl());
        Document newDoc = new Document();
        viewer.setDocument((IDocument)newDoc);
        viewer.setEditable(false);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LogWatcherView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        try {
            watcher = new TextFileWatcher(file, interval, numLines);
            watcher.setFilters(filters);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        final WatcherData entry = new WatcherData(viewer, watcher, newItem, filters);
        this.m_watchers.add(entry);
        this.addWatcherListener(newDoc, watcher, entry);
        viewer.getTextWidget().addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                Iterator iter = entry.getFilters().iterator();
                while (iter.hasNext()) {
                    Filter f = (Filter)iter.next();
                    if (!f.matches(event.lineText)) continue;
                    f.handleViewerMatch(event);
                }
            }
        });
        Font f = LogwatcherPlugin.getDefault().getFont("logwatcherFont");
        viewer.getTextWidget().setFont(f);
        watcher.start();
        this.m_closeAction.setEnabled(true);
        this.m_clearAction.setEnabled(true);
        this.m_scrollAction.setEnabled(true);
        this.m_editAction.setEnabled(true);
        if (saveState) {
            this.saveWatcherState();
        }
    }

    private void addWatcherListener(final Document doc, TextFileWatcher watcher, final WatcherData entry) {
        final Display display = Display.getCurrent();
        watcher.addListener(new WatcherUpdateListener(){

            public void update(BoundedList list) {
                BoundedList flist = list;
                display.asyncExec(new Runnable(this, entry, flist, doc){
                    final /* synthetic */ 5 this$1;
                    private final /* synthetic */ WatcherData val$entry;
                    private final /* synthetic */ BoundedList val$flist;
                    private final /* synthetic */ Document val$doc;
                    {
                        this.this$1 = var1_1;
                        this.val$entry = watcherData;
                        this.val$flist = boundedList;
                        this.val$doc = document;
                    }

                    public void run() {
                        this.val$entry.getViewer().getTextWidget().append(this.val$flist.getFormattedText());
                        if (this.val$entry.isScroll()) {
                            this.val$entry.getViewer().setTopIndex(this.val$doc.getNumberOfLines());
                        }
                    }
                });
            }
        });
    }

    public void editWatcher(WatcherData entry, int interval, int numLines, Vector filters) {
        entry.getWatcher().setInterval(interval);
        entry.getWatcher().setNumLines(numLines);
        entry.getWatcher().setFilters(filters);
        entry.setFilters(filters);
        this.saveWatcherState();
    }

    private void saveWatcherState() {
        IPath path = LogwatcherPlugin.getDefault().getStateLocation();
        path = path.addTrailingSeparator();
        path = path.append(WATCHER_STATE_FILENAME);
        try {
            org.w3c.dom.Document doc = XmlUtils.createDocument();
            Element watcher = doc.createElement("watchers");
            doc.appendChild(watcher);
            Iterator iter = this.m_watchers.iterator();
            while (iter.hasNext()) {
                WatcherData element = (WatcherData)iter.next();
                element.toXML(doc, watcher);
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(path.toFile());
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception e) {
            LogwatcherPlugin.getDefault().logError("Error saving watcher state", e);
        }
    }

    public CTabFolder getFolder() {
        return this.m_folder;
    }

    public void setFolder(CTabFolder folder) {
        this.m_folder = folder;
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.m_folder.getShell(), (String)"LogWatcher", (String)message);
    }

    public void setFocus() {
        this.m_folder.setFocus();
    }

    public void dispose() {
        super.dispose();
        Iterator iter = this.m_watchers.iterator();
        while (iter.hasNext()) {
            WatcherData entry = (WatcherData)iter.next();
            entry.dispose();
        }
        LogwatcherPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.m_propListener);
    }

    private WatcherData findEntry(CTabItem item) {
        Iterator iter = this.m_watchers.iterator();
        while (iter.hasNext()) {
            WatcherData entry = (WatcherData)iter.next();
            if (entry.getTab() != item) continue;
            return entry;
        }
        return null;
    }

    public WatcherData getSelectedEntry() {
        return this.findEntry(this.m_folder.getSelection());
    }
}

