/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher.watchers;

import java.io.File;
import java.io.Reader;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.graysky.eclipse.logwatcher.filters.Filter;
import org.graysky.eclipse.logwatcher.filters.FilterLoader;
import org.graysky.eclipse.logwatcher.views.LogWatcherView;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WatcherLoader {
    FilterLoader filterLoader = new FilterLoader();
    private LogWatcherView m_view;

    public WatcherLoader(LogWatcherView view) {
        this.m_view = view;
    }

    public void loadWatchers(Reader r) throws Exception {
        Document doc = this.createDocument(r);
        this.loadWatchers(doc);
    }

    public void loadWatchers(Document doc) {
        NodeList watcherNodes = doc.getElementsByTagName("watcher");
        int i = 0;
        while (i < watcherNodes.getLength()) {
            Node node = watcherNodes.item(i);
            this.loadWatcher(node);
            ++i;
        }
    }

    protected void loadWatcher(Node watcherNode) {
        File file = null;
        int interval = 0;
        int numLines = 0;
        Vector<Filter> filters = new Vector<Filter>();
        NodeList children = watcherNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            String name = node.getNodeName();
            if (name.equals("file")) {
                file = new File(node.getFirstChild().getNodeValue());
            } else if (name.equals("numLines")) {
                numLines = Integer.parseInt(node.getFirstChild().getNodeValue());
            } else if (name.equals("interval")) {
                interval = Integer.parseInt(node.getFirstChild().getNodeValue());
            } else if (name.equals("filter")) {
                filters.add(this.filterLoader.loadFilter(node));
            }
            ++i;
        }
        this.m_view.addWatcher(file, interval, numLines, filters, false);
    }

    protected Document createDocument(Reader r) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(new InputSource(r));
        return document;
    }
}

