/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.yaml.editors;

import hiro.yoshioka.yaml.dom.YamlParser;
import hiro.yoshioka.yaml.editors.IYamlFileChangedListener;
import hiro.yoshioka.yaml.editors.text.YamlOutlinePage;
import hiro.yoshioka.yaml.editors.text.YamlTextEditor;
import java.io.StringWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class YamlEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private TextEditor yamlTextEditor;
    private Font font;
    private StyledText text;
    private ScheduledExecutorService fScheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private Future future;
    List<IYamlFileChangedListener> fileChangeListenerList;
    YamlOutlinePage outlinePage;

    public YamlEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void addYamlFileChangedListener(IYamlFileChangedListener listener) {
        if (this.fileChangeListenerList == null) {
            this.fileChangeListenerList = new ArrayList<IYamlFileChangedListener>();
        }
        if (!this.fileChangeListenerList.contains(listener)) {
            this.fileChangeListenerList.add(listener);
        }
    }

    public void removeYamlFileChangedListener(IYamlFileChangedListener listener) {
        if (this.fileChangeListenerList == null) {
            return;
        }
        this.fileChangeListenerList.remove(listener);
    }

    protected IDocument getDocument() {
        return this.yamlTextEditor.getDocumentProvider().getDocument((Object)this.yamlTextEditor.getEditorInput());
    }

    public String getYamlText() {
        return this.getDocument().get();
    }

    private void resetParserDelay() {
        this.resetParserDelay(1000);
    }

    private void resetParserDelay(int milli) {
        this.cancelFuture();
        this.future = this.fScheduledExecutorService.schedule(new MyExecutor(), (long)milli, TimeUnit.MILLISECONDS);
    }

    private void cancelFuture() {
        if (this.future != null && !this.future.isCancelled()) {
            this.future.cancel(true);
        }
    }

    public void setYamlText(String yamlString) {
        this.getDocument().set(yamlString);
        this.resetParserDelay();
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    void createYamlTextPage() {
        try {
            this.yamlTextEditor = new YamlTextEditor();
            int index = this.addPage((IEditorPart)this.yamlTextEditor, this.getEditorInput());
            this.setPageText(index, this.yamlTextEditor.getTitle());
            this.resetParserDelay();
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this.outlinePage == null) {
                this.outlinePage = new YamlOutlinePage((YamlTextEditor)this.yamlTextEditor);
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    void createPage1() {
        Composite composite = new Composite(this.getContainer(), 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        layout.numColumns = 2;
        Button fontButton = new Button(composite, 0);
        GridData gd = new GridData(1);
        gd.horizontalSpan = 2;
        fontButton.setLayoutData((Object)gd);
        fontButton.setText("Change Font...");
        fontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                YamlEditor.this.setFont();
            }
        });
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Properties");
    }

    void createPage2() {
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.text = new StyledText(composite, 768);
        this.text.setEditable(false);
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Preview");
    }

    protected void createPages() {
        this.createYamlTextPage();
        this.createPage1();
        this.createPage2();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
        this.resetParserDelay();
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
        this.resetParserDelay();
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
        IFileEditorInput fi = (IFileEditorInput)editorInput;
        this.setPartName(fi.getName());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 2) {
            this.sortWords();
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = YamlEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)YamlEditor.this.yamlTextEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(YamlEditor.this.yamlTextEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    void setFont() {
        FontDialog fontDialog = new FontDialog(this.getSite().getShell());
        fontDialog.setFontList(this.text.getFont().getFontData());
        FontData fontData = fontDialog.open();
        if (fontData != null) {
            if (this.font != null) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.text.getDisplay(), fontData);
            this.text.setFont(this.font);
        }
    }

    void sortWords() {
        String editorText = this.yamlTextEditor.getDocumentProvider().getDocument((Object)this.yamlTextEditor.getEditorInput()).get();
        StringTokenizer tokenizer = new StringTokenizer(editorText, " \t\n\r\f!@#$%^&*()-_=+`~[]{};:'\",.<>/?|\\");
        ArrayList<String> editorWords = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            editorWords.add(tokenizer.nextToken());
        }
        Collections.sort(editorWords, Collator.getInstance());
        StringWriter displayText = new StringWriter();
        int i = 0;
        while (i < editorWords.size()) {
            displayText.write((String)editorWords.get(i));
            displayText.write(System.getProperty("line.separator"));
            ++i;
        }
        this.text.setText(displayText.toString());
    }

    class MyExecutor
    implements Runnable {
        MyExecutor() {
        }

        @Override
        public void run() {
            try {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IEditorInput ie = YamlEditor.this.yamlTextEditor.getEditorInput();
                        if (ie instanceof FileEditorInput) {
                            FileEditorInput fi = (FileEditorInput)ie;
                            try {
                                fi.getFile().deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                                ((MyExecutor)MyExecutor.this).YamlEditor.this.outlinePage.refresh(YamlParser.parseByFile(fi.getFile()));
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        } else {
                            String editorText = YamlEditor.this.yamlTextEditor.getDocumentProvider().getDocument((Object)YamlEditor.this.yamlTextEditor.getEditorInput()).get();
                            if (editorText.trim().length() > 0) {
                                ((MyExecutor)MyExecutor.this).YamlEditor.this.outlinePage.refresh(YamlParser.parseByString(editorText));
                            }
                        }
                        if (((MyExecutor)MyExecutor.this).YamlEditor.this.fileChangeListenerList != null) {
                            for (IYamlFileChangedListener listener : ((MyExecutor)MyExecutor.this).YamlEditor.this.fileChangeListenerList) {
                                listener.changed(ie);
                            }
                        }
                    }
                });
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

