/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.Map;
import java.util.Set;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.report.engine.adapter.ExpressionUtil;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StyledItemExecutor
extends ReportItemExecutor {
    private ExpressionUtil expressionUtil = new ExpressionUtil();

    protected StyledItemExecutor(ExecutorManager manager, int type) {
        super(manager, type);
    }

    protected void processStyle(ReportItemDesign design, IContent content) {
        Map<Integer, Expression> expressionStyles;
        HighlightDesign highlight = design.getHighlight();
        StyleDeclaration inlineStyle = null;
        if (highlight != null) {
            inlineStyle = this.createHighlightStyle(design.getHighlight());
        }
        if ((expressionStyles = design.getExpressionStyles()) != null) {
            if (inlineStyle == null) {
                inlineStyle = (StyleDeclaration)this.report.createStyle();
            }
            this.populateExpressionStyles(inlineStyle, expressionStyles);
        }
        if (inlineStyle != null) {
            content.setInlineStyle(inlineStyle);
        }
    }

    private void populateExpressionStyles(StyleDeclaration style, Map<Integer, Expression> expressionStyles) {
        Set<Map.Entry<Integer, Expression>> entrySet = expressionStyles.entrySet();
        for (Map.Entry<Integer, Expression> entry : entrySet) {
            Expression expression = entry.getValue();
            int propertyIndex = entry.getKey();
            if (expression == null) continue;
            String value = this.evaluateString(expression);
            style.setCssText(propertyIndex, value);
        }
    }

    protected void processColumnStyle(ColumnDesign columnDesign, IColumn column) {
        StyleDeclaration inlineStyle;
        HighlightDesign highlight = columnDesign.getHighlight();
        if (highlight != null && (inlineStyle = this.createHighlightStyle(highlight)) != null) {
            column.setInlineStyle(inlineStyle);
        }
    }

    private StyleDeclaration createHighlightStyle(HighlightDesign highlight) {
        StyleDeclaration style = (StyleDeclaration)this.report.createStyle();
        int i = 0;
        while (i < highlight.getRuleCount()) {
            HighlightRuleDesign rule = highlight.getRule(i);
            if (rule != null) {
                Boolean value;
                Expression expression = rule.getConditionExpr();
                if (expression == null) {
                    IConditionalExpression condExpr = null;
                    condExpr = rule.ifValueIsList() ? this.expressionUtil.createConditionExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1List()) : this.expressionUtil.createConditionalExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1(), rule.getValue2());
                    expression = Expression.newConditional(condExpr);
                    rule.setConditionExpr(expression);
                }
                if ((value = this.evaluateBoolean(expression)) != null && value.booleanValue()) {
                    style.setProperties(rule.getStyle());
                }
            }
            ++i;
        }
        return style;
    }

    protected void processMappingValue(StyledElementDesign item, IDataContent dataObj) {
        MapDesign map = item.getMap();
        if (map == null) {
            return;
        }
        int i = 0;
        while (i < map.getRuleCount()) {
            MapRuleDesign rule = map.getRule(i);
            if (rule != null) {
                Boolean value;
                Expression expression = rule.getConditionExpr();
                if (expression == null) {
                    IConditionalExpression condExpr = null;
                    condExpr = rule.ifValueIsList() ? this.expressionUtil.createConditionExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1List()) : this.expressionUtil.createConditionalExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1(), rule.getValue2());
                    expression = Expression.newConditional(condExpr);
                    rule.setConditionExpr(expression);
                }
                if ((value = this.evaluateBoolean(expression)) != null && value.booleanValue()) {
                    dataObj.setLabelText(rule.getDisplayText());
                    dataObj.setLabelKey(rule.getDisplayKey());
                }
            }
            ++i;
        }
    }
}

