/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.function;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.timefunction.IPeriodsFunction;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.AbstractMDX;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.TimeMemberUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeekToDateFunciton
extends AbstractMDX
implements IPeriodsFunction {
    private final long dayTimeInMills = 86400000L;

    @Override
    public List<TimeMember> getResult(TimeMember member) {
        ArrayList<TimeMember> timeMembers = new ArrayList<TimeMember>();
        String[] levelTypes = member.getLevelType();
        int[] values = member.getMemberValue();
        GregorianCalendar cal = new GregorianCalendar(TimeMemberUtil.getTimeZone(), TimeMemberUtil.getDefaultLocale());
        cal.clear();
        String baseType = this.translateToCal((Calendar)cal, levelTypes, values);
        if (this.isCurrent) {
            int weekDay = cal.get(7);
            while (weekDay < 7) {
                cal.add(6, 1);
                weekDay = cal.get(7);
            }
        }
        if (baseType.equals("week")) {
            timeMembers.add(member);
        } else if (baseType.equals("day")) {
            int weekday = cal.get(7);
            GregorianCalendar newCal = new GregorianCalendar(TimeMemberUtil.getTimeZone(), TimeMemberUtil.getDefaultLocale());
            int i = 1;
            while (i <= weekday) {
                newCal.setTimeInMillis(cal.getTimeInMillis() - (long)(weekday - i) * 86400000L);
                int[] tmp = this.getValueFromCal((Calendar)newCal, levelTypes);
                TimeMember timeMember = new TimeMember(tmp, levelTypes);
                timeMembers.add(timeMember);
                ++i;
            }
        }
        return timeMembers;
    }
}

