/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.SimpleLevelFilter;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryResults;
import org.eclipse.birt.data.engine.olap.util.OlapQueryUtil;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedCubeQuery
implements IPreparedCubeQuery {
    private ICubeQueryDefinition cubeQueryDefn;
    private DataEngineSession session;
    private DataEngineContext context;
    private Map appContext;
    private List<SimpleLevelFilter> internalFilters;
    private Map<String, Set<String>> inaccessibleDimLevels;

    public PreparedCubeQuery(ICubeQueryDefinition defn, DataEngineSession session, DataEngineContext context, Map appContext) throws DataException {
        this.cubeQueryDefn = defn;
        this.session = session;
        this.context = context;
        this.appContext = appContext;
        this.internalFilters = new ArrayList<SimpleLevelFilter>();
        if (!this.containsDrillFilter(defn)) {
            this.validateQuery();
        }
    }

    public void setInAccessibleDimLevels(Map<String, Set<String>> inaccessibleDimLevels) {
    }

    public Map<String, Set<String>> getInaccessibleDimLevels() {
        return null;
    }

    public List<SimpleLevelFilter> getInternalFilters() {
        return this.internalFilters;
    }

    @Override
    public ICubeQueryResults execute(Scriptable scope) throws DataException {
        return this.execute(null, scope);
    }

    @Override
    public ICubeQueryResults execute(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
        ScriptableObject cubeScope = null;
        try {
            cubeScope = ((IDataScriptEngine)this.session.getEngineContext().getScriptContext().getScriptEngine("javascript")).getJSContext(this.session.getEngineContext().getScriptContext()).initStandardObjects();
            cubeScope.setParentScope(scope == null ? this.session.getSharedScope() : scope);
            cubeScope.setPrototype(scope == null ? this.session.getSharedScope() : scope);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        Object delegateObject = null;
        try {
            delegateObject = Thread.currentThread().getContextClassLoader().loadClass("org.eclipse.birt.data.engine.olap.impl.query.PreparedCubeQueryDelegate").getConstructor(ICubeQueryDefinition.class, DataEngineSession.class, DataEngineContext.class, Map.class).newInstance(this.cubeQueryDefn, this.session, this.context, this.appContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (delegateObject != null) {
            try {
                Method method = delegateObject.getClass().getMethod("execute", IBaseQueryResults.class, Scriptable.class);
                return (ICubeQueryResults)method.invoke(delegateObject, outerResults, scope);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return new CubeQueryResults(outerResults, this, this.session, (Scriptable)cubeScope, this.context, this.appContext);
    }

    @Override
    public IBaseCubeQueryDefinition getCubeQueryDefinition() {
        return this.cubeQueryDefn;
    }

    private void validateQuery() throws DataException {
        this.validateBinding();
    }

    private void validateBinding() throws DataException {
        OlapQueryUtil.validateBinding(this.cubeQueryDefn, false);
    }

    private boolean containsDrillFilter(ICubeQueryDefinition defn) {
        if (defn.getEdge(1) != null && !defn.getEdge(1).getDrillFilter().isEmpty()) {
            return true;
        }
        return defn.getEdge(2) != null && !defn.getEdge(2).getDrillFilter().isEmpty();
    }

    public boolean isFromDataMart() {
        return false;
    }

    public void setFromDataMart(boolean isFromDataMart) {
    }
}

