/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.EmbeddedImage;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.PatternImage;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.util.PatternImageUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class FillCanvas
extends Canvas
implements PaintListener,
DisposeListener {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.composites");
    protected Fill fCurrent = null;
    private boolean isAutoEnabled = false;
    private IDeviceRenderer idr;
    private int textIndent = 0;

    public FillCanvas(Composite parent, int iStyle) {
        super(parent, iStyle);
        this.addPaintListener(this);
        this.addDisposeListener(this);
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            this.idr = null;
            WizardBase.displayException((Throwable)pex);
        }
    }

    public FillCanvas(Composite parent, int iStyle, boolean isAutoEnabled) {
        this(parent, iStyle);
        this.isAutoEnabled = isAutoEnabled;
    }

    public void setTextIndent(int indent) {
        this.textIndent = indent;
    }

    public void setFill(Fill fill) {
        this.fCurrent = fill;
    }

    public void paintControl(PaintEvent pe) {
        Color cBackground = null;
        try {
            try {
                Color clrTransparencyBackground = Display.getCurrent().getSystemColor(25);
                GC gc = pe.gc;
                if (!this.isEnabled()) {
                    gc.setBackground(Display.getCurrent().getSystemColor(22));
                    Color cFore = Display.getCurrent().getSystemColor(16);
                    gc.setForeground(cFore);
                    if (this.fCurrent == null || this.fCurrent instanceof ColorDefinition && ((ColorDefinition)this.fCurrent).getTransparency() == 0) {
                        gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
                        if (!this.isAutoEnabled || this.fCurrent != null) {
                            gc.drawText(Messages.getString("FillCanvas.Transparent"), 2 + this.textIndent, 2);
                        } else {
                            gc.drawText(Messages.getString("FillCanvas.Auto"), 2 + this.textIndent, 2);
                        }
                    } else {
                        gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
                        gc.setBackground(cFore);
                        gc.fillRectangle(2, 2, this.getSize().x - 4, this.getSize().y - 4);
                    }
                } else {
                    if (this.fCurrent == null || this.fCurrent instanceof ColorDefinition && ((ColorDefinition)this.fCurrent).getTransparency() == 0) {
                        gc.setBackground(clrTransparencyBackground);
                        gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
                        Color cText = Display.getDefault().getSystemColor(24);
                        gc.setForeground(cText);
                        if (!this.isAutoEnabled || this.fCurrent != null) {
                            gc.drawText(Messages.getString("FillCanvas.Transparent"), 2 + this.textIndent, 2);
                        } else {
                            gc.drawText(Messages.getString("FillCanvas.Auto"), 2 + this.textIndent, 2);
                        }
                        cText.dispose();
                    } else if (this.fCurrent instanceof ColorDefinition) {
                        cBackground = new Color((Device)Display.getDefault(), ((ColorDefinition)this.fCurrent).getRed(), ((ColorDefinition)this.fCurrent).getGreen(), ((ColorDefinition)this.fCurrent).getBlue());
                        gc.setBackground(cBackground);
                        gc.fillRectangle(2, 2, this.getSize().x - 4, this.getSize().y - 4);
                    } else if (this.fCurrent instanceof Image) {
                        org.eclipse.swt.graphics.Image img = this.getSWTImage((Image)this.fCurrent);
                        if (this.fCurrent instanceof PatternImage) {
                            Pattern ptn = new Pattern((Device)Display.getCurrent(), img);
                            gc.setBackgroundPattern(ptn);
                            gc.fillRectangle(2, 2, this.getSize().x - 4, this.getSize().y - 4);
                            ptn.dispose();
                        } else {
                            gc.fillRectangle(2, 2, this.getSize().x - 4, this.getSize().y - 4);
                            gc.drawImage(img, 2, 2);
                        }
                        if (img != null) {
                            img.dispose();
                        }
                    } else if (this.fCurrent instanceof Gradient) {
                        this.fillGradient(gc);
                    } else if (this.fCurrent instanceof MultipleFill) {
                        this.fillMultiFill(gc);
                    }
                    if (this.isFocusControl()) {
                        gc.setLineStyle(3);
                        gc.setForeground(Display.getCurrent().getSystemColor(2));
                        gc.drawRectangle(1, 1, this.getSize().x - 3, this.getSize().y - 3);
                    }
                }
            }
            catch (Exception ex) {
                logger.log(ex);
                if (cBackground != null) {
                    cBackground.dispose();
                }
            }
        }
        finally {
            if (cBackground != null) {
                cBackground.dispose();
            }
        }
    }

    private void fillPolygonWithIdr(GC gc, Fill fill, Location[] la) {
        this.idr.setProperty("device.output.context", (Object)gc);
        PolygonRenderEvent event = new PolygonRenderEvent((Object)this);
        event.setPoints(la);
        event.setBackground(fill);
        try {
            this.idr.fillPolygon(event);
        }
        catch (ChartException chartException) {}
    }

    protected void fillGradient(GC gc) {
        Location[] la = LocationImpl.create((double[])new double[]{2.0, 2.0, this.getSize().x - 2, this.getSize().x - 2}, (double[])new double[]{2.0, this.getSize().y - 2, this.getSize().y - 2, 2.0});
        this.fillPolygonWithIdr(gc, this.fCurrent, la);
    }

    private void fillMultiFill(GC gc) {
        MultipleFill mFill = (MultipleFill)this.fCurrent;
        double width = this.getSize().x - 4;
        double height = this.getSize().y - 4;
        Location[] la = LocationImpl.create((double[])new double[]{2.0, 2.0, width / 2.0 + 2.0, width / 2.0 + 2.0}, (double[])new double[]{2.0, height + 2.0, height + 2.0, 2.0});
        this.fillPolygonWithIdr(gc, (Fill)mFill.getFills().get(0), la);
        la = LocationImpl.create((double[])new double[]{width / 2.0 + 2.0, width / 2.0 + 2.0, width + 2.0, width + 2.0}, (double[])new double[]{2.0, height + 2.0, height + 2.0, 2.0});
        this.fillPolygonWithIdr(gc, (Fill)mFill.getFills().get(1), la);
    }

    private org.eclipse.swt.graphics.Image getSWTImage(Image modelImage) {
        org.eclipse.swt.graphics.Image img = null;
        try {
            if (modelImage instanceof EmbeddedImage) {
                String imageData = ((EmbeddedImage)modelImage).getData();
                if (imageData != null) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(Base64.decodeBase64((byte[])imageData.getBytes()));
                    img = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), (InputStream)bis);
                } else {
                    img = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), 10, 10);
                }
            } else if (modelImage instanceof PatternImage) {
                PatternImage patternImage = (PatternImage)modelImage;
                Display device = Display.getCurrent();
                PaletteData paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                byte[] data = PatternImageUtil.createImageData((PatternImage)patternImage, (PatternImageUtil.ByteColorModel)PatternImageUtil.ByteColorModel.BGRA);
                ImageData imageData = new ImageData(8, 8, 32, paletteData, 4, data);
                img = new org.eclipse.swt.graphics.Image((Device)device, imageData);
            } else {
                try {
                    img = new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), new URL(modelImage.getURL()).openStream());
                }
                catch (MalformedURLException malformedURLException) {
                    img = new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), (InputStream)new FileInputStream(modelImage.getURL()));
                }
            }
        }
        catch (FileNotFoundException ex) {
            logger.log((Exception)ex);
            ex.printStackTrace();
        }
        catch (IOException ex) {
            logger.log((Exception)ex);
            ex.printStackTrace();
        }
        return img;
    }

    public void setEnabled(boolean bState) {
        super.setEnabled(bState);
        this.redraw();
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.idr != null) {
            this.idr.dispose();
            this.idr = null;
        }
    }
}

