/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.model;

import hiro.yoshioka.gef.model.AssistTextPropertyDescriptor;
import hiro.yoshioka.gef.model.Messages;
import hiro.yoshioka.gef.model.MyRectangle;
import hiro.yoshioka.gef.model.PropertyAwareObject;
import hiro.yoshioka.gef.model.Schema;
import hiro.yoshioka.gef.model.Table;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class CommonConditionModel
extends PropertyAwareObject {
    public static final String P_COLUMN_NAME = "_column_name";
    public static final String P_CONDITION_TEXT = "_conditionText";
    public static final String P_COMPARATOR = "_comparator";
    static final String[] COMP = new String[]{"=", "<", "<=", ">=", ">", " LIKE ", " IN ", " IS NULL ", " IS NOT NULL "};
    private String conditionText = "";
    private int Comparator_idx;
    private String column_name = "";
    private Schema schema;
    private MyRectangle bounds;

    public void modifyBounds(Rectangle bounds) {
        MyRectangle oldBounds = this.bounds;
        if (!bounds.equals((Object)oldBounds)) {
            this.bounds = new MyRectangle(bounds);
            this.firePropertyChange("BOUNDS", null, bounds);
        }
    }

    public void setConstraint(Rectangle constraint) {
        this.bounds = new MyRectangle(constraint);
    }

    public MyRectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(MyRectangle bounds) {
        this.bounds = bounds;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        String[] cols = this.schema.getAllColumnNames();
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new AssistTextPropertyDescriptor(this, P_COLUMN_NAME, Messages.getString("CommonConditionModel.Column"), cols), new ComboBoxPropertyDescriptor((Object)P_COMPARATOR, Messages.getString("CommonConditionModel.Compare"), COMP), new TextPropertyDescriptor((Object)P_CONDITION_TEXT, Messages.getString("CommonConditionModel.Vaues"))};
        return descriptors;
    }

    @Override
    public Object getPropertyValue(Object id) {
        try {
            if (P_CONDITION_TEXT.equals(id)) {
                return this.conditionText;
            }
            if (P_COMPARATOR.equals(id)) {
                return new Integer(this.Comparator_idx);
            }
            if (P_COLUMN_NAME.equals(id)) {
                return this.column_name;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean isPropertySet(Object id) {
        return false;
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (id.equals(P_CONDITION_TEXT)) {
            this.setConditionText((String)value);
        } else if (id.equals(P_COLUMN_NAME)) {
            this.setColumn_name((String)value);
        } else if (id.equals(P_COMPARATOR)) {
            this.setComparator_idx((Integer)value);
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void appendConditionString(Table table, StringBuffer buff) {
        int i = 0;
        while (i < table.columns.size()) {
            if (table.columns.get((int)i).column.getName().equalsIgnoreCase(this.column_name)) {
                if (buff.length() > 0) {
                    buff.append(" AND ");
                }
                buff.append("T0.").append(this.getConditionValue());
                break;
            }
            ++i;
        }
    }

    public String getConditionText() {
        return this.conditionText;
    }

    public String getConditionValue() {
        if (this.column_name.trim().length() > 0 && this.conditionText.trim().length() > 0) {
            return String.valueOf(this.column_name) + COMP[this.Comparator_idx] + this.conditionText;
        }
        return "";
    }

    public void setConditionText(String conditionText) {
        this.conditionText = conditionText;
        this.firePropertyChange(P_CONDITION_TEXT, null, this.getConditionValue());
    }

    public int getComparator_idx() {
        return this.Comparator_idx;
    }

    public void setComparator_idx(int comparator_idx) {
        this.Comparator_idx = comparator_idx;
        this.firePropertyChange(P_CONDITION_TEXT, null, this.getConditionValue());
    }

    public String getColumn_name() {
        return this.column_name;
    }

    public void setColumn_name(String column_name) {
        this.column_name = column_name;
        this.firePropertyChange(P_CONDITION_TEXT, null, this.getConditionValue());
    }
}

