/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.part;

import hiro.yoshioka.gef.model.PropertyAwareObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public abstract class PropertyAwarePart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    protected Log fLogger = LogFactory.getLog(this.getClass());

    public void activate() {
        super.activate();
        PropertyAwareObject propertyAwareObject = (PropertyAwareObject)this.getModel();
        propertyAwareObject.addPropertyChangeListener(this);
    }

    public void deactivate() {
        super.deactivate();
        PropertyAwareObject propertyAwareObject = (PropertyAwareObject)this.getModel();
        propertyAwareObject.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if ("CHILD".equals(property)) {
            this.handleChildChange(evt);
        }
        if ("OUTPUT".equals(property)) {
            this.handleOutputChange(evt);
        } else if ("INPUT".equals(property)) {
            this.handleInputChange(evt);
        } else if ("BOUNDS".equals(property)) {
            this.handleBoundsChange(evt);
        } else if ("LAYOUT".equals(property)) {
            this.handleLayoutChange(evt);
        }
        if ("NAME".equals(property)) {
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)this.getViewer().getContents();
            IFigure partFigure = graphicalEditPart.getFigure();
            partFigure.getUpdateManager().performUpdate();
        }
    }

    private void handleInputChange(PropertyChangeEvent evt) {
        this.fLogger.warn((Object)("" + evt));
        this.refreshSourceConnections();
        this.refreshTargetConnections();
        this.getContentPane().revalidate();
    }

    private void handleOutputChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        this.fLogger.warn((Object)("newValue:" + newValue + " oldValue:" + oldValue));
        this.refreshSourceConnections();
        this.refreshTargetConnections();
        this.getContentPane().revalidate();
    }

    protected void handleChildChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (!(oldValue != null ^ newValue != null)) {
            throw new IllegalStateException("Exactly one of old or new values must be non-null for CHILD event");
        }
        if (newValue != null) {
            EditPart editPart = this.createChild(newValue);
            int modelIndex = this.getModelChildren().indexOf(newValue);
            this.addChild(editPart, modelIndex);
        } else {
            List children = this.getChildren();
            EditPart partToRemove = null;
            for (EditPart part : children) {
                if (part.getModel() != oldValue) continue;
                partToRemove = part;
                break;
            }
            if (partToRemove != null) {
                this.removeChild(partToRemove);
            }
        }
    }

    protected void handleLayoutChange(PropertyChangeEvent evt) {
    }

    protected void handleBoundsChange(PropertyChangeEvent evt) {
    }
}

