/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.tabbedview;

import hiro.yoshioka.gef.model.Column;
import hiro.yoshioka.gef.model.CommonConditionModel;
import hiro.yoshioka.gef.model.Table;
import hiro.yoshioka.gef.tabbedview.AbsBaseSection;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.ui.util.MySubjectControlContentAssistant;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.ArrayList;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ConditionSection
extends AbsBaseSection {
    MySubjectControlContentAssistant assistant;
    MySubjectControlContentAssistant assistant2;
    private Text whereText;
    private Text orderByText;
    private Button btDistinct;
    private Button btComment;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            int i = 0;
            while (i < ConditionSection.this.models.length) {
                if (ConditionSection.this.models[i] instanceof Table) {
                    if (arg0.widget.equals(ConditionSection.this.whereText)) {
                        ((Table)ConditionSection.this.models[i]).setConditionValue(ConditionSection.this.whereText.getText());
                    } else {
                        ((Table)ConditionSection.this.models[i]).setOrderByValue(ConditionSection.this.orderByText.getText());
                    }
                } else if (ConditionSection.this.models[i] instanceof CommonConditionModel) {
                    ((CommonConditionModel)ConditionSection.this.models[i]).setConditionText(ConditionSection.this.whereText.getText());
                }
                ++i;
            }
        }
    };
    private SelectionAdapter selListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int i = 0;
            while (i < ConditionSection.this.models.length) {
                if (ConditionSection.this.models[i] instanceof Table) {
                    if (e.widget.equals(ConditionSection.this.btDistinct)) {
                        ((Table)ConditionSection.this.models[i]).setExecute_distinct(ConditionSection.this.btDistinct.getSelection());
                    } else {
                        ((Table)ConditionSection.this.models[i]).setAs_comment(ConditionSection.this.btComment.getSelection());
                    }
                }
                ++i;
            }
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        try {
            GridData layoutData = (GridData)parent.getLayoutData();
            layoutData.horizontalAlignment = 4;
            layoutData.verticalAlignment = 4;
            layoutData.grabExcessHorizontalSpace = true;
            layoutData.grabExcessVerticalSpace = true;
            super.createControls(parent, aTabbedPropertySheetPage);
            GridLayout gl = new GridLayout(4, false);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 3;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)gl);
            new CLabel(composite, 0).setText("WHERE:");
            this.whereText = new Text(composite, 2052);
            this.whereText.setLayoutData((Object)gd);
            this.assistant = new MySubjectControlContentAssistant(this.whereText);
            new CLabel(composite, 0).setText("ORDER BY:");
            this.orderByText = new Text(composite, 2052);
            this.orderByText.setLayoutData((Object)gd);
            this.assistant2 = new MySubjectControlContentAssistant(this.orderByText);
            new CLabel(composite, 0).setText("AS COMMENT:");
            this.btComment = new Button(composite, 32);
            new CLabel(composite, 0).setText("DISTINCT:");
            this.btDistinct = new Button(composite, 32);
            this.refresh();
        }
        catch (Exception e) {
            this.fLogger.error((Object)e);
        }
    }

    public boolean hasCommonCondition() {
        if (this.models != null && this.models.length > 0) {
            int i = 0;
            while (i < this.models.length) {
                if (this.models[i] instanceof CommonConditionModel) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void refresh() {
        DatabaseType db_type = Application.getActiveSchemaDiagramDatabaseType();
        if (this.models != null && this.models.length > 0) {
            if (this.models[0] instanceof Table) {
                Table tbl = (Table)this.models[0];
                this.whereText.setText(tbl.getConditionValue());
                this.orderByText.setText(tbl.getOrderByValue());
                this.btComment.setSelection(tbl.isAs_comment());
                this.btDistinct.setSelection(tbl.isExecute_distinct());
                ArrayList<Column> columns = tbl.getColumns();
                String[] cols = new String[columns.size()];
                int i = 0;
                while (i < cols.length) {
                    cols[i] = db_type.needsColumnNameQuote(columns.get(i).getColumn().getName()) ? String.format("\"%s\"", columns.get(i).getColumn().getName()) : columns.get(i).getColumn().getName();
                    ++i;
                }
                if (cols != null) {
                    this.assistant.setProposalStrings(cols);
                    this.assistant2.setProposalStrings(cols);
                }
            } else if (this.models[0] instanceof CommonConditionModel) {
                CommonConditionModel cfr_ignored_0 = (CommonConditionModel)this.models[0];
                this.assistant.setProposalStrings(StringUtil.EMPTY_STRING_ARRAY);
                this.assistant2.setProposalStrings(StringUtil.EMPTY_STRING_ARRAY);
                this.whereText.setText("");
                this.orderByText.setText("");
            } else {
                this.assistant.setProposalStrings(StringUtil.EMPTY_STRING_ARRAY);
                this.assistant2.setProposalStrings(StringUtil.EMPTY_STRING_ARRAY);
                this.whereText.setText("");
                this.orderByText.setText("");
            }
        }
        this.whereText.removeModifyListener(this.listener);
        this.orderByText.removeModifyListener(this.listener);
        this.btComment.removeSelectionListener((SelectionListener)this.selListener);
        this.btDistinct.removeSelectionListener((SelectionListener)this.selListener);
        this.whereText.addModifyListener(this.listener);
        this.orderByText.addModifyListener(this.listener);
        this.btComment.addSelectionListener((SelectionListener)this.selListener);
        this.btDistinct.addSelectionListener((SelectionListener)this.selListener);
        if (this.hasCommonCondition()) {
            this.orderByText.setEditable(false);
            this.btComment.setEnabled(false);
            this.btDistinct.setEnabled(false);
        } else {
            this.orderByText.setEditable(true);
            this.btComment.setEnabled(true);
            this.btDistinct.setEnabled(true);
        }
    }
}

