/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.generator.bean;

import hiro.yoshioka.generator.CustomizedFormatter;
import hiro.yoshioka.generator.MyFormatter;
import hiro.yoshioka.generator.RandomFormatter;
import hiro.yoshioka.generator.SequenceFormatter;
import hiro.yoshioka.generator.TextFormatter;
import hiro.yoshioka.generator.XxxFormatter;
import hiro.yoshioka.generator.bean.GroupGeneratorBean;
import hiro.yoshioka.generator.formatter.GenerateFormatDef;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GeneratorBean {
    public static final int ALL_FORMATTER = -1;
    protected int numOfGroupInCounter;
    private GroupGeneratorBean parent;
    private List<MyFormatter> formatterList = new ArrayList<MyFormatter>();

    public GeneratorBean() {
    }

    public GeneratorBean(GroupGeneratorBean groupGenerator) {
        this.parent = groupGenerator;
    }

    public GroupGeneratorBean getParent() {
        return this.parent;
    }

    public void setParent(GroupGeneratorBean parent) {
        this.parent = parent;
    }

    public List<MyFormatter> getFormatterList() {
        return this.formatterList;
    }

    public void setFormatterList(List<MyFormatter> formatterList) {
        this.formatterList = formatterList;
    }

    public GroupGeneratorBean getGroupGenerator() {
        return this.parent;
    }

    public String getFormatDefinition() {
        if (this.formatterList.size() == 1) {
            MyFormatter formatter = this.formatterList.get(0);
            return formatter.getFormat();
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.formatterList.size()) {
            buf.append(this.formatterList.get(i).getFormat());
            ++i;
        }
        return buf.toString();
    }

    public String getExtraFormatDefinition() {
        if (this.formatterList.size() == 1) {
            MyFormatter formatter = this.formatterList.get(0);
            return formatter.getExtraFormat();
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.formatterList.size()) {
            buf.append(this.formatterList.get(i).getExtraFormat());
            ++i;
        }
        return buf.toString();
    }

    public String format() {
        Date today = new Date();
        if (this.formatterList.size() == 1) {
            return this.formatterList.get(0).formatedString(1, 1, 1, today);
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.formatterList.size()) {
            buf.append(this.formatterList.get(i).formatedString(1, i, i, today));
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        return String.valueOf(this.parent.getColumn().getName()) + "[" + this.format() + "]";
    }

    public boolean validate() {
        return true;
    }

    public TextFormatter setTextFormat() {
        this.formatterList.clear();
        TextFormatter formatter = new TextFormatter(this);
        this.formatterList.add(formatter);
        return formatter;
    }

    public RandomFormatter setRandomFormat() {
        this.formatterList.clear();
        RandomFormatter formatter = new RandomFormatter(this);
        this.formatterList.add(formatter);
        return formatter;
    }

    public SequenceFormatter setDefaultFormat() {
        this.formatterList.clear();
        SequenceFormatter formatter = new SequenceFormatter(this);
        this.formatterList.add(formatter);
        return formatter;
    }

    public XxxFormatter setXxxFormat() {
        this.formatterList.clear();
        XxxFormatter formatter = new XxxFormatter(this);
        this.formatterList.add(formatter);
        return formatter;
    }

    public CustomizedFormatter[] setCustomizedFormat(GenerateFormatDef[] def) {
        this.formatterList.clear();
        int i = 0;
        while (i < def.length) {
            CustomizedFormatter formatter = new CustomizedFormatter(this, def[i]);
            this.formatterList.add(formatter);
            ++i;
        }
        return this.formatterList.toArray(new CustomizedFormatter[this.formatterList.size()]);
    }

    public void setGroupInCounter(int numOfGroupInCounter) {
        this.numOfGroupInCounter = numOfGroupInCounter;
    }
}

