/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import com.mongodb.util.ThreadUtil;
import hiro.yoshioka.job.DBResourceDiffJob;
import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.GettingResourceRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.wolfdbmanager.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DBRefreshJob
extends Job {
    protected Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    GettingResourceRequest fRequest;
    Object fSelectionObject;
    ConnectionProperties prop;
    DBRoot before_root;

    public DBRefreshJob(SQLOperationType operationType, Object info, ConnectionProperties prop) {
        super("Refresh DB Definision...");
        this.fSelectionObject = info;
        this.prop = prop;
        this.before_root = prop.getDBRootResource();
    }

    protected void canceling() {
        this.fRequest.cancel();
        super.canceling();
    }

    protected IStatus run(IProgressMonitor monitor) {
        SQLServerThread.getSQLServer().getTransactionSQL(this.prop);
        IStatus ret = Status.CANCEL_STATUS;
        try {
            ThreadUtil.sleep((long)500L);
            this.fRequest = new GettingResourceRequest(this.prop);
            if (this.fSelectionObject instanceof IDBResource) {
                this.fRequest.selectionResource = (IDBResource)this.fSelectionObject;
                if (this.fSelectionObject instanceof IDBSchema) {
                    this.fRequest.targetType = GettingResourceRequest.GettingTarget.ONLY_SCHEMA;
                } else if (this.fSelectionObject instanceof IDBTable) {
                    this.fRequest.targetType = GettingResourceRequest.GettingTarget.ONLY_TABLE;
                }
            }
            this.fRequest.addListener((IRequestListener)new ResourceRefreshRequest(monitor));
            SQLServerThread.runNowThisRequest((Request)this.fRequest);
            Thread.yield();
            ret = Status.OK_STATUS;
        }
        catch (Exception e) {
            this.fLogger.error((Object)"", (Throwable)e);
            ret = Status.CANCEL_STATUS;
        }
        return ret;
    }

    class ResourceRefreshRequest
    extends RequestAdaptor {
        IProgressMonitor fmonitor;
        long startTime;
        boolean doneTableTask;

        public ResourceRefreshRequest(IProgressMonitor monitor) {
            this.fmonitor = monitor;
        }

        public void called_pre(Request request, SQLOperationType operation) {
            Application.setStatus("Refresh DB Definitions");
            this.startTime = System.currentTimeMillis();
        }

        public void beginTask(final String taskName, final int row) {
            try {
                Application.exec(new Runnable(){

                    @Override
                    public void run() {
                        ResourceRefreshRequest.this.fmonitor.beginTask(taskName, row);
                    }
                });
                if (!this.doneTableTask && (taskName.startsWith("DatabaseMetaData#getProcedures") || taskName.startsWith("SELECT ALL TAB COLS"))) {
                    this.doneTableTask = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void called_done(final Request request, SQLOperationType operation, final ConnectionProperties properteis, Object o) {
            Application.exec(new Runnable(){

                @Override
                public void run() {
                    ResourceRefreshRequest.this.fmonitor.subTask("");
                    String n = String.format("Refresh Done... %1$,dmsec.", System.currentTimeMillis() - ResourceRefreshRequest.this.startTime);
                    DBRefreshJob.this.setName(n);
                    Application.setStatus(n);
                    if (((ResourceRefreshRequest)ResourceRefreshRequest.this).DBRefreshJob.this.before_root != null && properteis.getDBRootResource() != null) {
                        DBResourceDiffJob diff_job = new DBResourceDiffJob(((ResourceRefreshRequest)ResourceRefreshRequest.this).DBRefreshJob.this.before_root, properteis.getDBRootResource(), properteis.getDatabaseType());
                        diff_job.setSystem(true);
                        diff_job.schedule();
                    }
                    if (request.getException() == null) {
                        if (ResourceRefreshRequest.this.fmonitor.isCanceled()) {
                            Application.openDialog("Information", "Resource caption canseled", 2);
                        }
                    } else if (ResourceRefreshRequest.this.fmonitor.isCanceled()) {
                        Application.openErrorDialog(null, "ResourceCaption Canseled", request.getException());
                    } else {
                        Application.openErrorDialog(null, "ResourceCaption", request.getException());
                    }
                }
            });
        }

        public void subTask(final String subTaskName) {
            try {
                Application.exec(new Runnable(){

                    @Override
                    public void run() {
                        ResourceRefreshRequest.this.fmonitor.subTask(subTaskName);
                    }
                });
                "SELECT FUNCTIONS".equals(subTaskName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void worked(final int i) {
            try {
                Application.exec(new Runnable(){

                    @Override
                    public void run() {
                        if (ResourceRefreshRequest.this.fmonitor.isCanceled()) {
                            ((ResourceRefreshRequest)ResourceRefreshRequest.this).DBRefreshJob.this.fRequest.cancel();
                        } else {
                            ResourceRefreshRequest.this.fmonitor.worked(i);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

