/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sdh.StringRecordDataHolder;
import hiro.yoshioka.sdh.diff.DiffToResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.ui.view.DiffResultSetView;
import hiro.yoshioka.wolfdbmanager.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DBResourceDiffJob
extends Job {
    protected transient Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    DBRoot old;
    DBRoot current;
    DatabaseType db_type;

    public DBResourceDiffJob(DBRoot old, DBRoot current, DatabaseType db_type) {
        super("DBResource Diff Job");
        this.old = old;
        this.current = current;
        this.db_type = db_type;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus ret = Status.CANCEL_STATUS;
        try {
            int n;
            int n2;
            if (this.old != null && this.current != null) {
                monitor.beginTask("Check db resource modify", 4);
            }
            DiffToResultSetDataHolder[] r = new DiffToResultSetDataHolder[]{new DiffToResultSetDataHolder()};
            int[] matchKeys = new int[]{1, 2};
            String[] header = new String[]{"Table name", "Column name", "Type", "Size", "Comment"};
            ResultSetDataHolder2 before_rdh = new ResultSetDataHolder2(header, null, this.db_type);
            before_rdh.setTableNameE("Before");
            IDBSchema[] iDBSchemaArray = this.old.getSchemas();
            int n3 = iDBSchemaArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IDBSchema schema = iDBSchemaArray[n4];
                if (schema != null) {
                    IDBTable[] iDBTableArray = schema.getTableOrViews();
                    n2 = iDBTableArray.length;
                    int n5 = 0;
                    while (n5 < n2) {
                        IDBTable table = iDBTableArray[n5];
                        if (table != null) {
                            IDBColumn[] iDBColumnArray = table.getColumns();
                            n = iDBColumnArray.length;
                            int n6 = 0;
                            while (n6 < n) {
                                IDBColumn column = iDBColumnArray[n6];
                                before_rdh.addRow(new String[]{table.getName(), column.getName(), column.getDataTypeString(), "" + column.getSize(), column.getComment()});
                                ++n6;
                            }
                        }
                        ++n5;
                    }
                }
                ++n4;
            }
            monitor.worked(1);
            ResultSetDataHolder2 new_rdh = new ResultSetDataHolder2(header, null, this.db_type);
            new_rdh.setTableNameE("Current");
            IDBSchema[] iDBSchemaArray2 = this.current.getSchemas();
            int n7 = iDBSchemaArray2.length;
            n3 = 0;
            while (n3 < n7) {
                IDBSchema schema = iDBSchemaArray2[n3];
                if (schema != null) {
                    IDBTable[] iDBTableArray = schema.getTableOrViews();
                    int n8 = iDBTableArray.length;
                    n2 = 0;
                    while (n2 < n8) {
                        IDBTable table = iDBTableArray[n2];
                        if (table != null) {
                            IDBColumn[] iDBColumnArray = table.getColumns();
                            int n9 = iDBColumnArray.length;
                            n = 0;
                            while (n < n9) {
                                IDBColumn column = iDBColumnArray[n];
                                new_rdh.addRow(new String[]{table.getName(), column.getName(), column.getDataTypeString(), "" + column.getSize(), column.getComment()});
                                ++n;
                            }
                        }
                        ++n2;
                    }
                }
                ++n3;
            }
            monitor.worked(1);
            r[0].diffConfigure((StringRecordDataHolder)before_rdh, (StringRecordDataHolder)new_rdh, matchKeys);
            r[0].setCase_insensitive(true);
            r[0].diff();
            monitor.worked(1);
            int total_diff = r[0].getSumDelete() + r[0].getSumInsert() + r[0].getSumUpdate();
            if (total_diff > 0) {
                monitor.worked(1);
                Application.exec(new Runnable(){

                    @Override
                    public void run() {
                        DiffResultSetView view = Application.showAndCreateDiffRstView("DB Update info (" + total_diff + ")");
                        view.setPartName("DB Update info (" + total_diff + ")");
                        try {
                            String message = String.format("Diff columns", new Object[0]);
                            view.setMessage(message);
                            view.setConnectionPropertiesDisplay("Before");
                            view.setTargetConnectionPropertiesDisplay("Current");
                        }
                        catch (Exception exception) {}
                        view.setInput(r, true);
                        view.disableNextDiff();
                    }
                });
            }
        }
        catch (Throwable e) {
            this.fLogger.warn((Object)"", e);
            ret = Status.CANCEL_STATUS;
        }
        return ret;
    }
}

