/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.preferences.DefaultTitleAreaDialog;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBResourceType;
import hiro.yoshioka.sql.resource.view.DBResourceTreeSelection;
import hiro.yoshioka.sql.util.CreateDBResourceHelper;
import hiro.yoshioka.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;

public class ModifyDBResourceDialog
extends DefaultTitleAreaDialog {
    Button btCasdade;
    private ConnectionProperties targetConnectionProperties;
    Composite innerSchema;
    private DBResourceTreeSelection fDBResourceTreeSelection;
    private DBResourceType dType;
    private SQLOperationType operation;
    private String name;
    private String comment;
    private Text nameText;
    private Text commentText;
    private String dialogTitle;
    private Map<CreateDBResourceHelper.TypedEnum, Control> control_map = new HashMap<CreateDBResourceHelper.TypedEnum, Control>();
    private Map<CreateDBResourceHelper.TypedEnum, String> control_result_string_map = new HashMap<CreateDBResourceHelper.TypedEnum, String>();

    public ModifyDBResourceDialog(Shell shell, ConnectionProperties p, SQLOperationType operation, DBResourceTreeSelection treeSelection, DBResourceType dType) {
        super(shell);
        this.operation = operation;
        this.targetConnectionProperties = p;
        this.fDBResourceTreeSelection = treeSelection;
        this.dType = dType;
    }

    @Override
    public void create() {
        super.create();
        this.validate();
    }

    @Override
    String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    @Override
    void createDialogAreaSub(Composite parent) {
        Section basicSection = this.toolkit.createSection(parent, 320);
        basicSection.setText("[1] Basic Information");
        Composite innerC = this.toolkit.createComposite((Composite)basicSection);
        innerC.setLayout((Layout)new GridLayout(2, false));
        this.nameText = this.createInputText(innerC, "Name:", "");
        this.commentText = this.createInputText(innerC, "Comment:", "");
        basicSection.setClient((Control)innerC);
        basicSection.setLayoutData((Object)this.createGridHSpanData(2));
        Section extraSection = this.toolkit.createSection(parent, 320);
        extraSection.setText("[2] Options");
        Composite innerO = this.toolkit.createComposite((Composite)extraSection);
        innerO.setLayout((Layout)new GridLayout(2, false));
        List typeList = CreateDBResourceHelper.getCreateProperties((DatabaseType)this.getTargetConnectionProperties().getDatabaseType(), (DBResourceType)this.dType);
        for (CreateDBResourceHelper.TypedProperty tproperty : typeList) {
            CreateDBResourceHelper.TypedEnum type = tproperty.getType();
            Object ctrl = null;
            if (CreateDBResourceHelper.TypedEnum.Owner.equals((Object)type)) {
                ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(this.targetConnectionProperties);
                Set roles = sql.getLoginRoles();
                if (roles == null || roles.size() == 0) {
                    ctrl = this.createInputText(innerO, String.valueOf(tproperty.getType().getTitle()) + ":", StringUtil.nvl((Object)tproperty.getDefault_value()));
                } else {
                    String[] items = roles.toArray(new String[roles.size()]);
                    ctrl = this.createInputCombo(innerO, String.valueOf(tproperty.getType().getTitle()) + ":", items, StringUtil.nvl((Object)tproperty.getDefault_value()));
                }
            } else {
                ctrl = type.isBooleanClazz() ? this.createInputCheckButton(innerO, String.valueOf(tproperty.getType().getTitle()) + ":", (Boolean)tproperty.getDefault_value()) : (type.isIntegerClazz() ? this.createInputNumericSpiner(innerO, String.valueOf(tproperty.getType().getTitle()) + ":", 0, Integer.MAX_VALUE, (Integer)tproperty.getDefault_value()) : this.createInputText(innerO, String.valueOf(tproperty.getType().getTitle()) + ":", StringUtil.nvl((Object)tproperty.getDefault_value())));
            }
            this.control_map.put(type, (Control)ctrl);
        }
        extraSection.setClient((Control)innerO);
        extraSection.setLayoutData((Object)this.createGridHSpanData(2));
    }

    protected void okPressed() {
        this.name = this.nameText.getText();
        this.comment = this.commentText.getText();
        for (CreateDBResourceHelper.TypedEnum typed_enum : this.control_map.keySet()) {
            Control ctrl = this.control_map.get(typed_enum);
            if (ctrl == null) continue;
            if (CreateDBResourceHelper.TypedEnum.Owner.equals((Object)typed_enum)) {
                if (ctrl instanceof CCombo) {
                    CCombo combo = (CCombo)ctrl;
                    this.control_result_string_map.put(typed_enum, combo.getText());
                    continue;
                }
                this.control_result_string_map.put(typed_enum, ((Text)ctrl).getText());
                continue;
            }
            if (typed_enum.isBooleanClazz()) {
                this.control_result_string_map.put(typed_enum, String.valueOf(((Button)ctrl).getSelection()));
                continue;
            }
            if (typed_enum.isIntegerClazz()) {
                this.control_result_string_map.put(typed_enum, String.valueOf(((Spinner)ctrl).getSelection()));
                continue;
            }
            this.control_result_string_map.put(typed_enum, ((Text)ctrl).getText());
        }
        super.okPressed();
    }

    @Override
    protected void validate() {
        String newErrorMessage = null;
        Button bt = this.getButton(0);
        if (bt == null || this.nameText == null) {
            return;
        }
        if (this.nameText.getText().trim().length() == 0) {
            newErrorMessage = "name must not be null.";
        }
        this.setErrorMessage(newErrorMessage);
        bt.setEnabled(newErrorMessage == null);
    }

    public ConnectionProperties getTargetConnectionProperties() {
        return this.targetConnectionProperties;
    }

    public TransactionRequest getRequest() {
        TransactionRequest request = new TransactionRequest(this.operation, this.targetConnectionProperties, null);
        request.setPartName(this.name);
        if (!StringUtil.isEmpty((Object)this.comment)) {
            request.addExtra_Property("remarks", this.comment);
        }
        for (CreateDBResourceHelper.TypedEnum typed_enum : this.control_result_string_map.keySet()) {
            String value = this.control_result_string_map.get(typed_enum);
            if (StringUtil.isEmpty((Object)value)) continue;
            if (typed_enum.isBooleanClazz()) {
                request.addExtra_Property(typed_enum.name(), value);
                continue;
            }
            if (typed_enum.isIntegerClazz()) {
                request.addExtra_Property(typed_enum.name(), value);
                continue;
            }
            request.addExtra_Property(typed_enum.name(), value);
        }
        return request;
    }
}

