/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.action;

import hiro.yoshioka.job.DBRefreshJob;
import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.ui.action.HsqlServerManager;
import hiro.yoshioka.ui.action.Messages;
import hiro.yoshioka.ui.action.SQLAction;
import hiro.yoshioka.ui.view.ExplorerView;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.Date;
import org.eclipse.jface.resource.ImageDescriptor;

public class HsqlDBAction
extends SQLAction {
    ExplorerView view;
    boolean isServerAction;
    boolean forward;

    public HsqlDBAction(ExplorerView view, ConnectionProperties connectionProperties, boolean isServerAction, boolean forward) {
        super(SQLOperationType.CONNECT, 1, connectionProperties);
        this.view = view;
        this.isServerAction = isServerAction;
        this.forward = forward;
        String text = "";
        ImageDescriptor desc = null;
        if (isServerAction) {
            if (forward) {
                text = "Start Hsqldb Server Process";
                this.setEnabled(!HsqlServerManager.isRunning());
                desc = ImageUtil.getImageDescriptor((String)"action/running.gif");
            } else {
                text = "Shutdown Hsqldb Server Process";
                this.setEnabled(HsqlServerManager.isRunning());
                desc = ImageUtil.getImageDescriptor((String)"action/39cancel.gif");
            }
        } else if (forward) {
            text = "Start Hsqldb Server, and connect to hsql";
            desc = ImageUtil.getImageDescriptor((String)"action/32connect.gif");
            this.setEnabled(!HsqlServerManager.isRunning());
        }
        this.configureAction(text, text, desc);
        view = (ExplorerView)Application.findActiveView("ExplorerID");
    }

    @Override
    public void run() {
        try {
            try {
                this.setEnabled(false);
                if (this.isServerAction) {
                    if (this.forward) {
                        HsqlServerManager.getInstance().start();
                        Application.showErrorView();
                    } else {
                        HsqlServerManager.getInstance().stop();
                    }
                } else if (this.forward) {
                    HsqlServerManager.getInstance().start();
                    Application.showErrorView();
                    this.fRequest = new Request(this.fOperation, this.connectionProperties);
                    this.fRequest.addListener((IRequestListener)this);
                    SQLServerThread.putRequest((Request)this.fRequest);
                }
            }
            catch (RuntimeException e) {
                this.fLogger.error((Object)"", (Throwable)e);
                if (this.finalClearConnectionFlg) {
                    this.connectionProperties = null;
                }
                this.setEnabled(true);
            }
        }
        finally {
            if (this.finalClearConnectionFlg) {
                this.connectionProperties = null;
            }
            this.setEnabled(true);
        }
    }

    @Override
    public void called_done(Request request, SQLOperationType operation, ConnectionProperties properteis, Object o) {
        Application.setStatus(String.format(Messages.getString("ConnectAction.result_message"), new Date(), properteis.getDisplayString(), operation.name(), request.result));
        Throwable ex = this.fRequest.getException();
        if (ex != null) {
            Application.openErrorDialog(null, String.format(Messages.getString("ConnectAction.error_message"), properteis.getDisplayString()), ex);
        }
        if (this.fOperation == SQLOperationType.CONNECT && properteis.isConnected() && properteis.isCaptureResourceAfterTheConnectProcess()) {
            DBRefreshJob job = new DBRefreshJob(SQLOperationType.RESOURCE_CAPTION, properteis, properteis);
            job.setUser(true);
            job.schedule();
        }
    }
}

