/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view;

import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sdh2.ReflectionPreparedStatement;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.INameFamily;
import hiro.yoshioka.sql.util.CommentInfo;
import hiro.yoshioka.sql.util.GeneralTableShowRequest;
import hiro.yoshioka.ui.view.IResultSetView;
import hiro.yoshioka.ui.view.Messages;
import hiro.yoshioka.wolfdbmanager.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.ui.part.ViewPart;

public abstract class AbsResultSetView
extends ViewPart
implements IResultSetView {
    protected transient Log log = LogFactory.getLog(this.getClass());
    ResultSetDataHolder2 fResultSetDataHolder;
    protected CommentInfo comInfo;
    private String connectionPropertiesDisplayString;

    public ResultSetDataHolder2 getInput() {
        return this.fResultSetDataHolder;
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    public CommentInfo getCommentInfo() {
        return this.comInfo;
    }

    public boolean reflect() {
        try {
            this.lostFocus();
            ReflectionPreparedStatement[] st = this.fResultSetDataHolder.reflect();
            String disp = this.getConnectionPropertiesDisplay();
            ConnectionProperties p = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionPropertiesByDisplay(disp);
            ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(p);
            int i = 0;
            while (i < st.length) {
                sql.execute(st[i]);
                ++i;
            }
            Application.setStatus(Messages.getString("AbsResultSetView.0"));
            return true;
        }
        catch (Throwable e) {
            this.log.error((Object)"", e);
            Application.openErrorDialog(null, Messages.getString("AbsResultSetView.2"), e);
            return false;
        }
    }

    public void refresh() {
        TransactionRequest req = null;
        Object[] binds = this.fResultSetDataHolder.getBinds();
        String disp = this.getConnectionPropertiesDisplay();
        ConnectionProperties p = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionPropertiesByDisplay(disp);
        System.out.println("aaaaaaaa: has? " + this.fResultSetDataHolder.hasResultSetMetaData());
        IDBTable table = p.getDBRootResource().getTable(this.fResultSetDataHolder.getSchemaNameE(), this.fResultSetDataHolder.getTableNameE());
        req = new TransactionRequest(SQLOperationType.PREPARED_EXECUTE_QUERY, p, this.fResultSetDataHolder.getSqlStatement(), binds, (INameFamily)table);
        req.setPartName(this.getTitle());
        GeneralTableShowRequest tr = new GeneralTableShowRequest(req, this.fResultSetDataHolder.isForUpdate());
        tr.tableName = this.fResultSetDataHolder.getTableName();
        tr.tableNameE = this.fResultSetDataHolder.getTableNameE();
        tr.pkPositions = this.fResultSetDataHolder.getPkPositions();
        req.addListener((IRequestListener)tr);
        req.setTimeOut(PreferenceUtil.getInt("SQL_TIMEOUT_NUM"));
        Application.closeView(this.getTitle());
        SQLServerThread.putRequest((Request)req);
    }

    abstract void lostFocus();

    @Override
    public ResultSetDataHolder2[] getResultSetDataHolders() {
        return new ResultSetDataHolder2[]{this.fResultSetDataHolder};
    }

    @Override
    public String[] getSQLStatements() {
        String[] ret = new String[]{this.fResultSetDataHolder.getSqlStatement()};
        return ret;
    }

    @Override
    public int[][] getMatchingPos() {
        System.out.println("errrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr");
        return null;
    }

    @Override
    public String getConnectionPropertiesDisplay() {
        return this.connectionPropertiesDisplayString;
    }

    @Override
    public void setConnectionPropertiesDisplay(String connectionDisplayString) {
        this.connectionPropertiesDisplayString = connectionDisplayString;
    }
}

