/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.vaction;

import hiro.yoshioka.preferences.CompareDialog;
import hiro.yoshioka.sdh.StringRecordDataHolder;
import hiro.yoshioka.sdh.diff.DiffToResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.ui.view.DiffResultSetView;
import hiro.yoshioka.ui.view.ResultListsView;
import hiro.yoshioka.ui.view.SingleResultSetView;
import hiro.yoshioka.wolfdbmanager.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ResultSetCompareAction
implements IViewActionDelegate {
    protected transient Log fLogger = LogFactory.getLog(this.getClass());
    private ResultListsView fView;

    public void init(IViewPart view) {
        this.fView = (ResultListsView)view;
    }

    public void run(IAction action) {
        try {
            SingleResultSetView[] views = this.fView.getSelectedResultSetView();
            CompareDialog dialog = new CompareDialog(Display.getCurrent().getActiveShell());
            dialog.configure(views);
            if (dialog.open() == 0) {
                DiffToResultSetDataHolder differ = new DiffToResultSetDataHolder();
                ResultSetDataHolder2 dataL = views[0].getInput();
                ResultSetDataHolder2 dataR = views[1].getInput();
                differ.diffConfigure((StringRecordDataHolder)dataL, (StringRecordDataHolder)dataR, dialog.getCheckIndexes());
                differ.diff();
                String secondId = String.valueOf(views[0].getPartName()) + "<>" + views[1].getPartName();
                DiffResultSetView view = Application.showAndCreateDiffRstView(secondId);
                view.setPartName(secondId);
                view.setInput(new DiffToResultSetDataHolder[]{differ}, true);
            }
        }
        catch (Throwable e) {
            this.fLogger.error((Object)"", e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

