/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.MarignPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MarignSection
extends Section {
    protected MarignPropertyDescriptor marign;
    IDescriptorProvider provider;
    private int width = -1;
    private boolean fillMarign = false;

    public MarignSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    public void createSection() {
        this.getLabelControl(this.parent);
        this.getMarignControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public void layout() {
        GridData gd = (GridData)this.marign.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 1 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 1 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillMarign;
        }
    }

    public MarignPropertyDescriptor getMarignControl() {
        return this.marign;
    }

    protected MarignPropertyDescriptor getMarignControl(Composite parent) {
        if (this.marign == null) {
            this.marign = DescriptorToolkit.createMarignPropertyDescriptor(this.isFormStyle);
            if (this.getProvider() != null) {
                this.marign.setDescriptorProvider(this.getProvider());
            }
            this.marign.createControl(parent);
            this.marign.getControl().setLayoutData((Object)new GridData());
            this.marign.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    MarignSection.this.marign = null;
                }
            });
        } else {
            this.checkParent(this.marign.getControl(), parent);
        }
        return this.marign;
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.marign != null) {
            this.marign.setDescriptorProvider(provider);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setInput(Object input) {
        assert (input != null);
        this.marign.setInput(input);
    }

    public boolean isFillMarign() {
        return this.fillMarign;
    }

    public void setFillMarign(boolean fillMarign) {
        this.fillMarign = fillMarign;
    }

    public void load() {
        if (this.marign != null && !this.marign.getControl().isDisposed()) {
            this.marign.load();
        }
    }

    public void reset() {
        if (this.marign != null && !this.marign.getControl().isDisposed()) {
            this.marign.reset();
        }
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, isHidden);
        }
        if (this.marign != null) {
            this.marign.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.marign != null) {
            this.marign.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }
}

