/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.util.SelectValueFetcher;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.parameters.ParameterUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportValueDialog
extends BaseDialog {
    private boolean distinct = true;
    private boolean isRequired = true;
    private boolean hasNullValue = false;
    private String nullValue = "<null>";
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getElement("ScalarParameter").getProperty("dataType").getAllowedChoices();
    private static final String DLG_TITLE = Messages.getString((String)"ImportValueDialog.Title");
    private static final String LABEL_SELECT_DATASET = Messages.getString((String)"ImportValueDialog.Label.SelectDataSet");
    private static final String LABEL_SELECT_COLUMN = Messages.getString((String)"ImportValueDialog.Label.SelectColumn");
    private static final String LABEL_SELECT_VALUE = Messages.getString((String)"ImportValueDialog.Label.SelectValue");
    private Combo dataSetChooser;
    private Combo columnChooser;
    private Text valueEditor;
    private org.eclipse.swt.widgets.List valueList;
    private org.eclipse.swt.widgets.List selectedList;
    private Button add;
    private Button addAll;
    private Button remove;
    private Button removeAll;
    private String currentDataSetName;
    private ArrayList resultList = new ArrayList();
    private List columnList;
    private int selectedColumnIndex;
    private DataEngine engine;
    private String style;
    private List<String> choiceList;
    private int expectedColumnDataType;
    private int[] compatibleDataTypes;
    private IAddChoiceValidator validator;

    public ImportValueDialog(String style, List<String> choices) {
        super(DLG_TITLE);
        assert (DATA_TYPE_CHOICE_SET.contains(style));
        this.style = style;
        this.choiceList = choices;
        this.expectedColumnDataType = DataAdapterUtil.modelDataTypeToCoreDataType((String)style);
        try {
            this.compatibleDataTypes = DataAdapterUtil.getCompatibleDataTypes((int)this.expectedColumnDataType);
        }
        catch (AdapterException e) {
            e.printStackTrace();
        }
    }

    private String beforeValidateString(String value) {
        if (value.equals(this.nullValue) && this.hasNullValue) {
            if (this.isRequired) {
                return "";
            }
            return null;
        }
        return value;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public void setValidate(IAddChoiceValidator validator) {
        this.validator = validator;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createColumnSelectionArea(composite);
        this.createValueSelectionArea(composite);
        UIUtil.bindHelp((Control)composite, "org.eclipse.birt.cshelp.ImportValueDialog_ID");
        return composite;
    }

    private void createColumnSelectionArea(Composite parent) {
        Composite selectionArea = new Composite(parent, 0);
        selectionArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        selectionArea.setLayoutData((Object)new GridData(768));
        new Label(selectionArea, 0).setText(LABEL_SELECT_DATASET);
        this.dataSetChooser = new Combo(selectionArea, 12);
        this.dataSetChooser.setVisibleItemCount(30);
        this.dataSetChooser.setLayoutData((Object)new GridData(768));
        this.dataSetChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newSelection = ImportValueDialog.this.dataSetChooser.getText();
                if (!ImportValueDialog.this.currentDataSetName.equals(newSelection)) {
                    ImportValueDialog.this.currentDataSetName = newSelection;
                    ImportValueDialog.this.refreshColumns();
                }
            }
        });
        new Label(selectionArea, 0).setText(LABEL_SELECT_COLUMN);
        this.columnChooser = new Combo(selectionArea, 12);
        this.columnChooser.setLayoutData((Object)new GridData(768));
        this.columnChooser.setVisibleItemCount(30);
        this.columnChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newSelectedIndex = ImportValueDialog.this.columnChooser.getSelectionIndex();
                if (ImportValueDialog.this.selectedColumnIndex != newSelectedIndex) {
                    ImportValueDialog.this.selectedColumnIndex = newSelectedIndex;
                    ImportValueDialog.this.refreshValues();
                }
            }
        });
    }

    private void createValueSelectionArea(Composite parent) {
        Composite selectionArea = new Composite(parent, 0);
        selectionArea.setLayout((Layout)new GridLayout(3, false));
        selectionArea.setLayoutData((Object)new GridData(768));
        Composite subComposite = new Composite(selectionArea, 0);
        subComposite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        subComposite.setLayoutData((Object)new GridData(768));
        new Label(subComposite, 0).setText(LABEL_SELECT_VALUE);
        this.valueEditor = new Text(subComposite, 2052);
        this.valueEditor.setLayoutData((Object)new GridData(768));
        this.valueEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportValueDialog.this.filteValues();
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        new Label(selectionArea, 0).setLayoutData((Object)gd);
        this.valueList = new org.eclipse.swt.widgets.List(selectionArea, 2818);
        this.setListLayoutData(this.valueList);
        this.valueList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportValueDialog.this.addSelected();
            }

            public void widgetSelected(SelectionEvent e) {
                ImportValueDialog.this.updateButtons();
            }
        });
        Composite buttonBar = new Composite(selectionArea, 0);
        GridLayout layout = UIUtil.createGridLayoutWithoutMargin();
        buttonBar.setLayout((Layout)layout);
        this.addAll = new Button(buttonBar, 8);
        this.addAll.setText(">>");
        this.addAll.setToolTipText(Messages.getString((String)"ImportValueDialog.Button.AddAll.ToolTip"));
        this.addAll.setLayoutData((Object)new GridData(1816));
        this.addAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportValueDialog.this.addAll();
            }
        });
        this.add = new Button(buttonBar, 8);
        this.add.setText(">");
        this.add.setToolTipText(Messages.getString((String)"ImportValueDialog.Button.Add.ToolTip"));
        this.add.setLayoutData((Object)new GridData(768));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportValueDialog.this.addSelected();
            }
        });
        this.remove = new Button(buttonBar, 8);
        this.remove.setText("<");
        this.remove.setToolTipText(Messages.getString((String)"ImportValueDialog.Button.Remove.ToolTip"));
        this.remove.setLayoutData((Object)new GridData(768));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportValueDialog.this.removeSelected();
            }
        });
        this.removeAll = new Button(buttonBar, 8);
        this.removeAll.setText("<<");
        this.removeAll.setToolTipText(Messages.getString((String)"ImportValueDialog.Button.RemoveAll.ToolTip"));
        this.removeAll.setLayoutData((Object)new GridData(1810));
        this.removeAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportValueDialog.this.removeAll();
            }
        });
        this.selectedList = new org.eclipse.swt.widgets.List(selectionArea, 2818);
        this.setListLayoutData(this.selectedList);
        this.selectedList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportValueDialog.this.removeSelected();
            }

            public void widgetSelected(SelectionEvent e) {
                ImportValueDialog.this.updateButtons();
            }
        });
    }

    private void setListLayoutData(org.eclipse.swt.widgets.List list) {
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 200;
        list.setLayoutData((Object)gd);
    }

    private void addSelected() {
        String[] selected = this.valueList.getSelection();
        int selectedIndex = this.valueList.getSelectionIndex();
        int oldListSize = this.valueList.getItemCount();
        if (selected.length == 0 && (this.validator == null || this.validator != null && this.validator.validateString(this.beforeValidateString(this.valueEditor.getText())) == null)) {
            selected = new String[]{this.valueEditor.getText()};
        }
        int i = 0;
        while (i < selected.length) {
            if (this.selectedList.indexOf(selected[i]) == -1) {
                this.selectedList.add(selected[i]);
            }
            ++i;
        }
        this.filteValues();
        if (selected.length == 1) {
            int nextSelected = selectedIndex + 1 < oldListSize ? selectedIndex : selectedIndex - 1;
            this.valueList.select(nextSelected);
        } else if (selected.length > 1 && this.valueList.getItemCount() > 0) {
            this.valueList.select(0);
        }
        this.updateButtons();
    }

    private void addAll() {
        String[] values = this.valueList.getItems();
        int i = 0;
        while (i < values.length) {
            if (this.selectedList.indexOf(values[i]) == -1) {
                this.selectedList.add(values[i]);
            }
            ++i;
        }
        this.filteValues();
    }

    private void removeSelected() {
        int selectedIndex = this.selectedList.getSelectionIndex();
        int oldListSize = this.selectedList.getItemCount();
        String[] selected = this.selectedList.getSelection();
        int i = 0;
        while (i < selected.length) {
            this.selectedList.remove(selected[i]);
            ++i;
        }
        this.filteValues();
        if (selected.length == 1) {
            int nextSelected = selectedIndex + 1 < oldListSize ? selectedIndex : selectedIndex - 1;
            this.selectedList.select(nextSelected);
        } else if (selected.length > 1 && this.valueList.getItemCount() > 0) {
            this.selectedList.select(0);
        }
        this.updateButtons();
    }

    private void removeAll() {
        this.selectedList.removeAll();
        this.filteValues();
    }

    @Override
    protected boolean initDialog() {
        try {
            this.engine = DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)3, null, null, null));
        }
        catch (BirtException e) {
            ExceptionHandler.handle(e);
            return false;
        }
        this.dataSetChooser.setItems(ChoiceSetFactory.getDataSets());
        this.dataSetChooser.select(0);
        this.currentDataSetName = this.dataSetChooser.getText();
        this.selectedList.removeAll();
        for (String value : this.choiceList) {
            if (value != null) {
                this.selectedList.add(value);
                continue;
            }
            this.hasNullValue = true;
            this.selectedList.add(this.nullValue);
        }
        this.refreshColumns();
        return true;
    }

    private void refreshColumns() {
        DataSetHandle dataSetHandle = this.getDataSetHandle();
        try {
            this.columnList = DataUtil.getColumnList(dataSetHandle);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        this.columnChooser.removeAll();
        this.selectedColumnIndex = -1;
        if (this.columnList.size() == 0) {
            this.columnChooser.setItems(new String[0]);
        } else {
            for (ResultSetColumnHandle column : this.columnList) {
                if (!this.matchType(column)) continue;
                this.columnChooser.add(column.getColumnName());
                this.selectedColumnIndex = 0;
            }
        }
        this.columnChooser.select(this.selectedColumnIndex);
        this.columnChooser.setEnabled(this.selectedColumnIndex == 0);
        this.refreshValues();
    }

    private boolean matchType(ResultSetColumnHandle column) {
        if ("any".equals(column.getDataType())) {
            return true;
        }
        if (this.compatibleDataTypes != null && this.compatibleDataTypes.length > 0) {
            int columnType = DataAdapterUtil.adaptModelDataType((String)column.getDataType());
            int i = 0;
            while (i < this.compatibleDataTypes.length) {
                if (this.compatibleDataTypes[i] == columnType) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void refreshValues() {
        this.resultList.clear();
        if (this.columnChooser.isEnabled()) {
            String queryExpr = null;
            for (ResultSetColumnHandle column : this.columnList) {
                if (!column.getColumnName().equals(this.columnChooser.getText())) continue;
                queryExpr = DEUtil.getResultSetColumnExpression((String)column.getColumnName());
                break;
            }
            if (queryExpr == null) {
                return;
            }
            try {
                List modelValueList = SelectValueFetcher.getSelectValueList(queryExpr, this.getDataSetHandle(), true);
                if (modelValueList != null) {
                    Iterator iter = modelValueList.iterator();
                    DateFormatter formatter = new DateFormatter(ULocale.US);
                    while (iter.hasNext()) {
                        Object candiateValue = iter.next();
                        if (candiateValue != null) {
                            if (this.expectedColumnDataType == 9 && candiateValue instanceof Date) {
                                formatter.applyPattern("yyyy-MM-dd");
                                this.result = formatter.format((Date)candiateValue);
                            } else if (this.expectedColumnDataType == 10 && candiateValue instanceof Date) {
                                formatter.applyPattern("HH:mm:ss.SSS");
                                this.result = formatter.format((Date)candiateValue);
                            } else if (this.expectedColumnDataType == 6 && candiateValue instanceof Date) {
                                formatter.applyPattern("yyyy-MM-dd HH:mm:ss.SSS");
                                this.result = formatter.format((Date)candiateValue);
                            } else {
                                this.result = String.valueOf(candiateValue);
                            }
                        } else {
                            this.result = this.nullValue;
                            this.hasNullValue = true;
                        }
                        if (this.resultList.contains(this.result)) continue;
                        this.resultList.add(this.result);
                    }
                }
                this.filteValues();
            }
            catch (BirtException e) {
                ExceptionHandler.handle(e);
            }
        } else {
            this.valueList.removeAll();
            this.valueList.deselectAll();
            this.updateButtons();
        }
    }

    private void filteValues() {
        this.valueList.removeAll();
        this.valueList.deselectAll();
        for (String value : this.resultList) {
            try {
                if (this.selectedList.indexOf(value) != -1 || !value.startsWith(this.valueEditor.getText().trim()) && !value.matches(this.valueEditor.getText().trim()) || this.validator != null && (this.validator == null || this.validator.validateString(this.beforeValidateString(value)) != null)) continue;
                if (this.distinct) {
                    boolean exist = false;
                    int i = 0;
                    while (i < this.selectedList.getItemCount()) {
                        String selectValue = this.selectedList.getItem(i);
                        if (this.isEqual(selectValue, value)) {
                            exist = true;
                            break;
                        }
                        ++i;
                    }
                    if (exist) continue;
                    this.valueList.add(value);
                    continue;
                }
                this.valueList.add(value);
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.valueList.getSelectionCount() != 0) {
            this.add.setEnabled(true);
        } else if (this.valueEditor.getText().trim().length() != 0 && this.selectedList.indexOf(this.valueEditor.getText().trim()) == -1) {
            if (this.validator == null || this.validator != null && this.validator.validateString(this.beforeValidateString(this.valueEditor.getText().trim())) == null) {
                if (this.distinct) {
                    boolean exist = false;
                    int i = 0;
                    while (i < this.selectedList.getItemCount()) {
                        String selectValue = this.selectedList.getItem(i);
                        if (this.isEqual(selectValue, this.valueEditor.getText().trim())) {
                            exist = true;
                            break;
                        }
                        ++i;
                    }
                    if (exist) {
                        this.add.setEnabled(false);
                    } else {
                        this.add.setEnabled(true);
                    }
                } else {
                    this.add.setEnabled(true);
                }
            } else {
                this.add.setEnabled(false);
            }
        } else {
            this.add.setEnabled(false);
        }
        this.addAll.setEnabled(this.valueList.getItemCount() != 0);
        this.remove.setEnabled(this.selectedList.getSelectionCount() != 0);
        this.removeAll.setEnabled(this.selectedList.getItemCount() != 0);
        this.getOkButton().setEnabled(this.selectedList.getItemCount() != 0);
    }

    protected void okPressed() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(this.selectedList.getItems()));
        if (this.hasNullValue) {
            int i = 0;
            while (i < list.size()) {
                String item = (String)list.get(i);
                if (this.nullValue.equals(item)) {
                    list.remove(i);
                    if (this.isRequired) {
                        list.add(i, "");
                    } else {
                        list.add(i, null);
                    }
                }
                ++i;
            }
        }
        this.setResult(list.toArray(new String[0]));
        super.okPressed();
    }

    private DataSetHandle getDataSetHandle() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(this.currentDataSetName);
    }

    public boolean close() {
        if (this.engine != null) {
            this.engine.shutdown();
        }
        return super.close();
    }

    private boolean isEqual(String value1, String value2) {
        Object v1 = null;
        Object v2 = null;
        if (value1 == null && value2 != null || value1 != null && value2 == null) {
            return false;
        }
        try {
            v1 = this.validateValue(value1);
            v2 = this.validateValue(value2);
        }
        catch (BirtException birtException) {
            return false;
        }
        if (v1 == null) {
            return v2 == null;
        }
        if (v1 instanceof Double && v2 instanceof Double) {
            return ((Double)v1).compareTo((Double)v2) == 0;
        }
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return ((BigDecimal)v1).compareTo((BigDecimal)v2) == 0;
        }
        if (v1 instanceof Integer && v2 instanceof Integer) {
            return ((Integer)v1).compareTo((Integer)v2) == 0;
        }
        return v1.equals(v2);
    }

    private Object validateValue(String value) throws BirtException {
        String tempdefaultValue = value;
        if (!"string".equals(this.style) && !"boolean".equals(this.style)) {
            if ("dateTime".equals(this.style)) {
                tempdefaultValue = ParameterUtil.convertToStandardFormat(DataTypeUtil.toDate((Object)tempdefaultValue));
            } else if ("date".equals(this.style)) {
                tempdefaultValue = ParameterUtil.convertToStandardFormat(DataTypeUtil.toSqlDate((Object)tempdefaultValue));
            } else if ("time".equals(this.style)) {
                tempdefaultValue = ParameterUtil.convertToStandardFormat(DataTypeUtil.toSqlTime((Object)tempdefaultValue));
            }
            return ParameterValidationUtil.validate((String)this.style, (String)"MM/dd/yyyy hh:mm:ss a", (String)tempdefaultValue, (ULocale)ULocale.getDefault());
        }
        if ("boolean".equals(this.style)) {
            if (tempdefaultValue != null && tempdefaultValue.equals(Messages.getString((String)"ParameterDialog.Choice.NoDefault"))) {
                return DataTypeUtil.toBoolean(null);
            }
            return DataTypeUtil.toBoolean((Object)tempdefaultValue);
        }
        return tempdefaultValue;
    }

    public static interface IAddChoiceValidator {
        public String validateString(String var1);
    }
}

