/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.ImageHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Image;

public class ResetImageOriginalSizeAction
extends Action {
    public static final int BYORIGINAL = 0;
    public static final int BYIMAGEDPI = 1;
    public static final int BYREPORTDPI = 2;
    public static final int BYSCREENDPI = 3;
    private ImageHandle imageHandle;
    private String displayName;
    private int type;

    public ResetImageOriginalSizeAction(ImageHandle imageHandle, String displayName, int type) {
        this.imageHandle = imageHandle;
        this.displayName = displayName;
        this.type = type;
        this.setText(displayName);
    }

    public boolean isEnabled() {
        if (this.getImage() == null) {
            return false;
        }
        if (this.type == 3 || this.type == 0) {
            return true;
        }
        if (this.type == 2) {
            ModuleHandle handle = this.imageHandle.getModuleHandle();
            if (handle instanceof ReportDesignHandle) {
                return ((ReportDesignHandle)handle).getImageDPI() != 0;
            }
            return false;
        }
        if (this.type == 1) {
            return this.getImageDPI() != 0;
        }
        return false;
    }

    private int getImageDPI() {
        InputStream in = null;
        URL temp = null;
        String imageSource = this.imageHandle.getSource();
        String url = this.imageHandle.getURI();
        if ("expr".equalsIgnoreCase(imageSource)) {
            return 0;
        }
        if ("embed".equalsIgnoreCase(imageSource)) {
            EmbeddedImage embeddedImage = this.imageHandle.getModuleHandle().findImage(this.imageHandle.getImageName());
            if (embeddedImage == null) {
                return 0;
            }
            in = new ByteArrayInputStream(embeddedImage.getData(this.imageHandle.getModule()));
        } else if ("url".equalsIgnoreCase(imageSource)) {
            temp = ImageManager.getInstance().createURIURL(url);
            try {
                in = temp.openStream();
            }
            catch (IOException iOException) {
                in = null;
            }
        } else if ("file".equalsIgnoreCase(imageSource)) {
            try {
                temp = URIUtil.isValidResourcePath((String)url) ? ImageManager.getInstance().generateURL(this.imageHandle.getModuleHandle(), URIUtil.getLocalPath((String)url)) : ImageManager.getInstance().generateURL(this.imageHandle.getModuleHandle(), url);
                in = temp.openStream();
            }
            catch (IOException iOException) {
                in = null;
            }
        }
        int dpi = UIUtil.getImageResolution(in)[0];
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                ExceptionHandler.handle(e);
            }
        }
        return dpi;
    }

    private Image getImage() {
        ImageHandleAdapter adapter = HandleAdapterFactory.getInstance().getImageHandleAdapter((Object)this.imageHandle);
        return adapter.getImage();
    }

    public void run() {
        CommandStack stack = this.imageHandle.getModuleHandle().getCommandStack();
        stack.startTrans(Messages.getString((String)"ResetImageOriginalSizeAction.trans.label"));
        String defaultUnit = this.imageHandle.getModuleHandle().getDefaultUnits();
        Image image = this.getImage();
        int width = image.getBounds().width;
        int height = image.getBounds().height;
        try {
            if (this.type == 0) {
                this.imageHandle.setWidth(String.valueOf(width) + "px");
                this.imageHandle.setHeight(String.valueOf(height) + "px");
            } else {
                int dpi = 0;
                if (this.type == 3) {
                    dpi = UIUtil.getScreenResolution()[0];
                } else if (this.type == 2) {
                    dpi = ((ReportDesignHandle)this.imageHandle.getModuleHandle()).getImageDPI();
                } else if (this.type == 1) {
                    dpi = this.getImageDPI();
                }
                double inch = (double)width / (double)dpi;
                DimensionValue value = DimensionUtil.convertTo((double)inch, (String)"in", (String)defaultUnit);
                this.imageHandle.getWidth().setValue((Object)value);
                inch = (double)height / (double)dpi;
                value = DimensionUtil.convertTo((double)inch, (String)"in", (String)defaultUnit);
                this.imageHandle.getHeight().setValue((Object)value);
            }
        }
        catch (SemanticException e) {
            stack.rollbackAll();
            ExceptionHandler.handle(e);
            return;
        }
        stack.commit();
    }
}

