/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.resourcelocator;

import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ExtendedResourceFilter;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceFilter;

public class ResourceEntryFilter
implements ResourceEntry.Filter {
    private ResourceFilter[] filters;

    public ResourceEntryFilter(ResourceFilter[] filters) {
        this.filters = filters;
    }

    public boolean accept(ResourceEntry entity) {
        if (this.filters == null || this.filters.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.filters.length) {
            ResourceFilter filter = this.filters[i];
            if (filter.isEnabled()) {
                if (filter.getType().equals("cvs")) {
                    if (entity.getName().startsWith("CVS")) {
                        return false;
                    }
                } else if (filter.getType().equals(".")) {
                    if (entity.getName().startsWith(".") && !entity.getName().endsWith(".rptlibrary")) {
                        return false;
                    }
                } else if (filter.getType().equals("empty_folder")) {
                    if (!entity.isFile() && !entity.hasChildren()) {
                        return false;
                    }
                } else if (filter instanceof ExtendedResourceFilter) {
                    return ((ExtendedResourceFilter)filter).accept(entity);
                }
            }
            ++i;
        }
        return true;
    }
}

