// shortenDateValues.js

// Implict Objects
// LOG org.apache.commons.logging.Log
// FILE_NAME java.lang.String
// FILES[] java.io.File
// CI hiro.yoshioka.sql.util.CommentInfo


importPackage( Packages.hiro.yoshioka.util );

/**
 * after interceptor
 * @param rdh hiro.yoshioka.sdh.ResultSetDataHolder
 * @param table hiro.yoshioka.sql.resource.IDBTable
 */
function after(rdh, table) {
 LOG.warn('START shortenDateValues.js');

 if( rdh.hasResultSetMetaData() ) {
   var keys = rdh.getKey();
   var columnMetaList = rdh.getColumnList(false);

   var now = Packages.java.util.Calendar.getInstance();
   var targetCal = Packages.java.util.Calendar.getInstance();
   var thisYear = now.get(Packages.java.util.Calendar.YEAR);
   for (var i=0; i < rdh.getRowCount(); i++ ) {
      for(var colMetaIte = columnMetaList.iterator(); colMetaIte.hasNext(); ){
         var colMeta = colMetaIte.next();
         if ( !colMeta.getType().isDate() && !colMeta.getType().isTimeStamp() ) {
           continue;
         }
         var dateValue = rdh.getDateData(i, colMeta.getIndex());
         if ( dateValue != null ) {
            var dateStr = Packages.hiro.yoshioka.util.StringUtil.getShortenDate( dateValue );
            rdh.changeString(i, colMeta.getIndex(), dateStr);
         }
      }
   }
 }

 LOG.warn('END shortenDateValues.js');
}
