'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  MySaveAsDialog.vb                                       --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Dialogues                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports System.Text
Imports WomenWC.Managers.Manager

Namespace Dialogues
    Public Class MySaveAsDialog

        Private Const DLG_TITLE As String = "Otĕۑ"

        Private _saveAsDialog As SaveFileDialog

        Public Sub New()
            _saveAsDialog = New SaveFileDialog
            _saveAsDialog.CheckPathExists = True
            _saveAsDialog.RestoreDirectory = True                        
            _saveAsDialog.Title = DLG_TITLE
        End Sub

        Public ReadOnly Property FileName() As String
            Get
                Return _saveAsDialog.FileName
            End Get
        End Property

        Public Function ShowDialog() As DialogResult
            _saveAsDialog.Filter = SettingManager.SettingInfo.FileFilter
            Return _saveAsDialog.ShowDialog
        End Function


    End Class
End Namespace
