'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  DocumentForm.vb                                         --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Forms                                           --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Document
Imports WomenWCCore.Interfaces.Analyzer
Imports WomenWCCore.Interfaces.Editor
Imports WomenWC.Managers


Namespace Forms

    Public Class DocumentForm

        Private WithEvents _document As Document
        Private WithEvents _womenWCEditor As IWomenWCEditor

        Public Sub New(ByVal womenWCEditor As IWomenWCEditor)
            InitializeComponent()
            _document = womenWCEditor.Document
            _womenWCEditor = womenWCEditor
            _womenWCEditor.Location = New Point(0, 0)
            _womenWCEditor.Dock = DockStyle.Fill
            Me.Controls.Add(_womenWCEditor)

        End Sub

        Public ReadOnly Property WomenWCEditor() As IWomenWCEditor
            Get
                Return Me._womenWCEditor
            End Get
        End Property

        Public ReadOnly Property Document() As Document
            Get
                Return _document
            End Get
        End Property

    End Class

End Namespace