'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  ToolBarManagerSingleton.vb                              --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Managers                                        --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Menu
Imports WomenWC.Forms
Imports WomenWCCore.Interfaces.Menu
Imports Common

Namespace Managers
    Public Class ToolBarManagerSingleton

        Private _toolBarButtonProcessList As Dictionary(Of ToolStripButton, IMenuItemProcess)
        Private WithEvents _interception As Timer
        Private Shared _toolBarManager As ToolBarManagerSingleton

        Private Sub New()
            _toolBarButtonProcessList = New Dictionary(Of ToolStripButton, IMenuItemProcess)
            _interception = New Timer()
            _interception.Interval = 500
            _interception.Enabled = True
        End Sub

        Public Shared ReadOnly Property ToolBarManager() As ToolBarManagerSingleton
            Get
                If _toolBarManager Is Nothing Then
                    _toolBarManager = New ToolBarManagerSingleton
                End If
                Return _toolBarManager
            End Get
        End Property

        Public Sub Initialize(ByVal womenWCMainForm As WomenWCMainForm)

            AddToolBarButtonProcess(womenWCMainForm._toolBarNewProject, New File.OnNewProject(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarOpenProject, New File.OnOpenProject(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarOpenFile, New File.OnOpenFile(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarSave, New File.OnSave(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarSaveAll, New File.OnSaveAll(womenWCMainForm))

            AddToolBarButtonProcess(womenWCMainForm._toolBarUndo, New Edit.OnUndo(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarRedo, New Edit.OnRedo(womenWCMainForm))

            AddToolBarButtonProcess(womenWCMainForm._toolBarCut, New Edit.OnCut(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarCopy, New Edit.OnCopy(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarPaste, New Edit.OnPaste(womenWCMainForm))

            AddToolBarButtonProcess(womenWCMainForm._toolBarCommentOut, New Edit.OnCommentOut(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarCommentCancel, New Edit.OnCommentCancel(womenWCMainForm))

            AddToolBarButtonProcess(womenWCMainForm._toolBarFind, New Search.OnFind(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarFindPrev, New Search.OnPrevFind(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarFindNext, New Search.OnNextFind(womenWCMainForm))

            AddToolBarButtonProcess(womenWCMainForm._toolBarUnGoTo, New Search.OnUnGoTo(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarReGoTo, New Search.OnReGoTo(womenWCMainForm))

            AddToolBarButtonProcess(womenWCMainForm._toolBarSetBookMark, New Search.OnSetBookMark(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarPrevBookMark, New Search.OnPrevBookMark(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarNextBookMark, New Search.OnNextBookMark(womenWCMainForm))
            AddToolBarButtonProcess(womenWCMainForm._toolBarClearBookMark, New Search.OnClearBookMark(womenWCMainForm))

        End Sub

        Public Sub AddToolBarButtonProcess(ByVal toolBarButton As ToolStripButton, ByVal menuItemProcess As IMenuItemProcess)
            If Not _toolBarButtonProcessList.ContainsKey(toolBarButton) Then
                _toolBarButtonProcessList.Add(toolBarButton, menuItemProcess)
                AddHandler toolBarButton.Click, AddressOf OnToolBarButtonClick
            Else
            End If
        End Sub

        Private Sub OnToolBarButtonClick(ByVal sender As Object, ByVal e As System.EventArgs)
            If _toolBarButtonProcessList.ContainsKey(sender) AndAlso _toolBarButtonProcessList(sender) IsNot Nothing Then
                If _toolBarButtonProcessList(sender).IsEnable Then
                    DirectCast(sender, ToolStripButton).Enabled = True
                    Try
                        _toolBarButtonProcessList(sender).Execute()
                    Catch myex As MyException
                        Common.Message.ShowMessage(myex)
                    Catch ex As Exception
                        Common.Message.ShowMessage(ex)
                    End Try
                Else
                    DirectCast(sender, ToolStripButton).Enabled = False
                End If
            End If
        End Sub

        Private Sub OnInterceptionTick(ByVal sender As Object, ByVal e As System.EventArgs) Handles _interception.Tick
            For Each toolBarButton As ToolStripButton In _toolBarButtonProcessList.Keys
                If _toolBarButtonProcessList(toolBarButton) IsNot Nothing Then
                    toolBarButton.Enabled = _toolBarButtonProcessList(toolBarButton).IsEnable
                Else
                End If
            Next
        End Sub

    End Class
End Namespace

