'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnOpenProject.vb                                        --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.File                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Menu
Imports WomenWC.Forms
Imports WomenWC.Dialogues
Imports WomenWC.Managers.Manager

Namespace Menu.File
    Public Class OnOpenProject
        Inherits MenuItemProcessBase

        Private Const STR_COMMENT As String = "ۑĂWomenWCvWFNgJ"

        Private _openProjectDialog As MyOpenProjectDialog

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
            _openProjectDialog = New MyOpenProjectDialog
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides Sub Execute()
            Dim projectFileName As String

            If _openProjectDialog.ShowDialog = Windows.Forms.DialogResult.OK Then
                projectFileName = _openProjectDialog.FileName
                OpenProject(projectFileName)
            End If
        End Sub

        Private Sub OpenProject(ByVal projectFileName As String)

            DocumentFormManager.WindowCloseAll()
            ProjectManager.InitializeProjectInfo(projectFileName)
            DocumentManager.InitializeDocuments(ProjectManager.ProjectInfo)
            DocumentManager.InitializeBookMark(projectFileName)
            MemberManager.InitializeMemberInfosFromProjectInfo(ProjectManager.ProjectInfo)
            WomenWCMainForm._projectView.InitializeProjectTreeView()
            SettingManager.RefreshOpenProjectHistory(projectFileName)

        End Sub

    End Class
End Namespace
