'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnRecentProjectSubItem.vb                               --
'--                                                                           --
'--  Author(s)     :  Chen Qinghua (Three Swordsmen Team)                     --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.File                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWC.Managers.Manager

Namespace Menu.File
    Public Class OnRecentProjectSubItem
        Inherits MenuItemProcessBase

        Private _projectName As String
        Private Const STR_COMMENT As String = "w̃vWFNgJ"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm, ByVal projectName As String)
            MyBase.New(womenWCMainForm)
            _projectName = projectName
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides Sub Execute()
            OpenProject(_projectName)
        End Sub

        Private Sub OpenProject(ByVal projectFileName As String)

            DocumentFormManager.WindowCloseAll()
            ProjectManager.InitializeProjectInfo(projectFileName)
            DocumentManager.InitializeDocuments(ProjectManager.ProjectInfo)
            DocumentManager.InitializeBookMark(projectFileName)
            MemberManager.InitializeMemberInfosFromProjectInfo(ProjectManager.ProjectInfo)
            WomenWCMainForm._projectView.InitializeProjectTreeView()

        End Sub

    End Class

End Namespace
