'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnRecentProjects.vb                                     --
'--                                                                           --
'--  Author(s)     :  Chen Qinghua (Three Swordsmen Team)                     --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.File                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Infos.Setting
Imports WomenWCCore.Infos.Menu
Imports WomenWCCore.Interfaces.Menu
Imports WomenWC.Forms
Imports WomenWC.Managers.Manager

Namespace Menu.File
    Public Class OnRecentProjects
        Inherits MenuItemProcessBase

        Private Const STR_COMMENT As String = "ŋߊJvWFNgꗗ\"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                If SettingManager.SettingInfo.MaxRecentProjectCount > 0 AndAlso _
                   SettingManager.SettingInfo.RecentProjects.Count > 0 Then
                    Return True
                Else
                    Return False
                End If
            End Get
        End Property

        Public Overrides ReadOnly Property HasDynamicMenuItem() As Boolean
            Get
                Return True
            End Get
        End Property

        Public Overrides ReadOnly Property DynamicMenuItemInfos() As System.Collections.Generic.List(Of WomenWCCore.Infos.Menu.DynamicMenuItemInfo)
            Get
                Dim result As List(Of DynamicMenuItemInfo)
                Dim toolStripMenuItem As ToolStripMenuItem
                Dim menuItemProcess As IMenuItemProcess

                result = New List(Of DynamicMenuItemInfo)
                For Each recentProject As String In SettingManager.SettingInfo.RecentProjects
                    toolStripMenuItem = New ToolStripMenuItem(recentProject)
                    menuItemProcess = New OnRecentProjectSubItem(WomenWCMainForm, recentProject)
                    result.Add(New DynamicMenuItemInfo(toolStripMenuItem, menuItemProcess))
                Next
                Return result
            End Get
        End Property

        Public Overrides Sub Execute()

        End Sub

    End Class
End Namespace
