'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnSave.vb                                               --
'--                                                                           --
'--  Author(s)     :  He Hui (Three Swordsmen Team)                           --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.File                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWC.Managers.Manager

Namespace Menu.File
    Public Class OnSave
        Inherits MenuItemProcessBase

        Private Const STR_COMMENT As String = "ƒ̃t@C㏑ĕۑ"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                If DocumentFormManager.CurrentDocumentForm IsNot Nothing Then
                    Return True
                Else
                    Return False
                End If
            End Get
        End Property

        Public Overrides Sub Execute()
            Dim currentDocumentForm As DocumentForm
            currentDocumentForm = DocumentFormManager.CurrentDocumentForm

            If currentDocumentForm IsNot Nothing Then
                currentDocumentForm.Document.Save()
            Else
            End If
        End Sub
    End Class
End Namespace
