'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnSaveAll.vb                                            --
'--                                                                           --
'--  Author(s)     :  He Hui (Three Swordsmen Team)                           --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.File                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWC.Managers.Manager
Imports WomenWCCore

Namespace Menu.File
    Public Class OnSaveAll
        Inherits MenuItemProcessBase

        Private Const STR_COMMENT As String = "SĂ̊Jăt@C̕ۑ"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                If DocumentManager.Documents.Count > 0 Then
                    Return True
                Else
                    Return False
                End If
            End Get
        End Property

        Public Overrides Sub Execute()
            SaveAllDocument()
            ProjectManager.SaveProject()
        End Sub

        Public Sub SaveAllDocument()
            For Each doc As Document.Document In DocumentManager.Documents
                If doc.DocumentDirtyFlag = True Then
                    doc.Save()
                End If
            Next
        End Sub

    End Class
End Namespace
