'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnSaveAs.vb                                             --
'--                                                                           --
'--  Author(s)     :  He Hui (Three Swordsmen Team)                           --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.File                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWC.Dialogues
Imports WomenWC.Managers.Manager

Namespace Menu.File
    Public Class OnSaveAs
        Inherits MenuItemProcessBase

        Private _saveAsDialog As MySaveAsDialog
        Private Const STR_COMMENT As String = "ƒ̃t@CVOŕۑ"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
            _saveAsDialog = New MySaveAsDialog
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                If DocumentFormManager.CurrentDocumentForm IsNot Nothing Then
                    Return True
                Else
                    Return False
                End If
            End Get
        End Property

        Public Overrides Sub Execute()
            Dim currentDocumentForm As DocumentForm
            Dim documentName As String
            Dim analyzer As WomenWCCore.Interfaces.Analyzer.IWomenWCAnalyzer
            currentDocumentForm = DocumentFormManager.CurrentDocumentForm
           
            If currentDocumentForm IsNot Nothing AndAlso _saveAsDialog.ShowDialog = DialogResult.OK Then
                documentName = currentDocumentForm.Document.DocumentFileName
                analyzer = DocumentFormManager.DocumentForms(documentName).WomenWCEditor.WomenWCAnalyzer
                DocumentFormManager.Rename(documentName, _saveAsDialog.FileName)
                DocumentManager.Rename(documentName, _saveAsDialog.FileName)
                ProjectManager.RenameProgram(documentName, _saveAsDialog.FileName)
                currentDocumentForm.Document.Save()
                MemberManager.DeleteMembers(documentName)
                If analyzer Is Nothing Then
                    MemberManager.SetMembers(DocumentManager.Documents(_saveAsDialog.FileName), Nothing)
                Else
                    MemberManager.SetMembers(DocumentManager.Documents(_saveAsDialog.FileName), analyzer.WomenWCSyntax)
                End If
                WomenWCMainForm._projectView.Rename(documentName, _saveAsDialog.FileName)
            Else
            End If
        End Sub

    End Class
End Namespace
