'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnGPLNative.vb                                          --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.Help                                       --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Namespace Menu.Help

    Public Class OnGPLNative
        Inherits MenuItemProcessBase

        Private Const GPL_FILENAME As String = "Documents\GPL(Japanese).chm"
        Private Const STR_COMMENT As String = "{łGNUʌOp_񏑂\"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides Sub Execute()
            If IO.File.Exists(GPL_FILENAME) Then
                System.Windows.Forms.Help.ShowHelp(WomenWCMainForm, GPL_FILENAME)
            Else
            End If
        End Sub

    End Class

End Namespace
