'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnAddExistingFile.vb                                    --
'--                                                                           --
'--  Author(s)     :  He Hui (Three Swordsmen Team)                           --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.Project                                    --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Menu
Imports WomenWC.Forms
Imports WomenWC.Managers.Manager
Imports WomenWC.Dialogues

Namespace Menu.Project
    Public Class OnAddExistingFile
        Inherits WomenWC.Menu.MenuItemProcessBase

        Private Const STR_COMMENT As String = "t@CvWFNgɒǉ"
        Private _addExistingFileDialog As AddExistingFileDialog

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
            _addExistingFileDialog = New AddExistingFileDialog()
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                If ProjectManager.ProjectInfo Is Nothing Then
                    Return False
                Else
                    Return True
                End If
            End Get
        End Property

        Public Overrides Sub Execute()
            If Me._addExistingFileDialog.ShowDialog() = DialogResult.OK Then
                AddProgram(_addExistingFileDialog.SelectedPath, _addExistingFileDialog.SelectedAnalyzer)
            End If
        End Sub

        Private Sub AddProgram(ByVal newFileFullName As String, ByVal analyzerName As String)
            Dim analyzer As WomenWCCore.Interfaces.Analyzer.IWomenWCAnalyzer
            analyzer = AnalyzerManager.Analyzers(analyzerName)
            If DocumentManager.Documents(newFileFullName) Is Nothing Then
                DocumentManager.AddDocument(newFileFullName)
                ProjectManager.AddProgramInfo(newFileFullName, analyzerName)
                If analyzer Is Nothing Then
                    MemberManager.SetMembers(DocumentManager.Documents(newFileFullName), Nothing)
                Else
                    MemberManager.SetMembers(DocumentManager.Documents(newFileFullName), analyzer.WomenWCSyntax)
                End If
                WomenWCMainForm._projectView.InitializeProjectTreeView()
                DocumentFormManager.AddDocumentForm(DocumentManager.Documents(newFileFullName), analyzer)
                DocumentFormManager.ActivateDocumentForm(newFileFullName, FormWindowState.Maximized)
            Else
                If DocumentFormManager.DocumentForms(newFileFullName) Is Nothing Then
                    DocumentFormManager.AddDocumentForm(DocumentManager.Documents(newFileFullName), analyzer)
                    DocumentFormManager.ActivateDocumentForm(newFileFullName, FormWindowState.Maximized)
                End If
            End If
        End Sub

    End Class
End Namespace