'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnClearBookMark.vb                                      --
'--                                                                           --
'--  Author(s)     :  Chen Qinghua (Three Swordsmen Team)                     --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.Search                                     --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWC.Managers.Manager
Imports WomenWCCore.Document

Namespace Menu.Search
    Public Class OnClearBookMark
        Inherits MenuItemProcessBase

        Private Const STR_COMMENT As String = "ƒ̃t@C̃ubN}[NSĉ"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                If DocumentFormManager.CurrentDocumentForm IsNot Nothing Then
                    Return True
                Else
                    Return False
                End If
            End Get
        End Property

        Public Overrides Sub Execute()
            Dim currentDocForm As DocumentForm
            Dim currentDoc As Document
            Dim startRow As Integer

            currentDocForm = DocumentFormManager.CurrentDocumentForm
            If currentDocForm IsNot Nothing Then
                startRow = currentDocForm.WomenWCEditor.CaretPhysicalPosition.Row()
                currentDoc = currentDocForm.Document
                For i As Integer = 0 To currentDoc.DocumentLinesCount - 1
                    If currentDoc.DocumentLineBookMark(i) = True Then
                        currentDocForm.WomenWCEditor.SetBookMark(i, False)
                    End If
                Next
            End If
        End Sub

    End Class
End Namespace