'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnGoToDefine.vb                                         --
'--                                                                           --
'--  Author(s)     :  Chen Qinghua (Three Swordsmen Team)                     --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.Search                                     --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWC.Managers.Manager
Imports WomenWCCore.Document
Imports WomenWCCore.Enums
Imports WomenWCCore.Interfaces.Editor
Imports WomenWCCore.Interfaces.Analyzer
Imports WomenWCCore.Infos.Analyzer

Namespace Menu.Search
    Public Class OnGoToDefine
        Inherits MenuItemProcessBase

        Private Const STR_COMMENT As String = "J[\̈ʒuϐ܂͊֐̐錾sֈړ"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                If DocumentFormManager.CurrentDocumentForm IsNot Nothing AndAlso _
                   ProjectManager.ProjectInfo IsNot Nothing Then
                    Return True
                Else
                    Return False
                End If
            End Get
        End Property

        Public Overrides Sub Execute()
            Dim currentWord As WordInfo
            Dim currentPosition As Position
            Dim currentForm As DocumentForm
            Dim womenWCEditor As IWomenWCEditor
            Dim womenWCLex As IWomenWCLex
            Dim document As Document
            Dim functionInfo As FunctionInfo
            Dim variableInfo As VariableInfo

            currentForm = DocumentFormManager.CurrentDocumentForm

            If currentForm IsNot Nothing AndAlso _
               currentForm.WomenWCEditor.WomenWCAnalyzer IsNot Nothing AndAlso _
               currentForm.WomenWCEditor.WomenWCAnalyzer.WomenWCLex IsNot Nothing AndAlso _
               currentForm.Document IsNot Nothing Then

                womenWCEditor = currentForm.WomenWCEditor
                womenWCLex = womenWCEditor.WomenWCAnalyzer.WomenWCLex
                document = currentForm.Document
                currentPosition = womenWCEditor.CaretPhysicalPosition
                currentWord = womenWCLex.GetWordFromIndex(document.DocumentLineString(currentPosition.Row), currentPosition.Col)

                If currentWord.WordType = WordTypeEnum.NormalWord Then

                    functionInfo = MemberManager.GetFunctionInfo(document.DocumentFileName, currentWord.WordString, True)
                    If functionInfo IsNot Nothing Then
                        DocumentFormManager.ActivateDocumentForm(functionInfo.FunctionFileName, FormWindowState.Maximized)
                        DocumentFormManager.CurrentDocumentForm.WomenWCEditor.CaretMoveTo(functionInfo.MovePosition.Row, functionInfo.MovePosition.Col)
                        Return
                    Else
                    End If

                    variableInfo = MemberManager.GetVariableInfo(document.DocumentFileName, currentWord.WordString, True)
                    If variableInfo IsNot Nothing Then
                        DocumentFormManager.ActivateDocumentForm(variableInfo.VariableFileName, FormWindowState.Maximized)
                        DocumentFormManager.CurrentDocumentForm.WomenWCEditor.CaretMoveTo(variableInfo.MovePosition.Row, variableInfo.MovePosition.Col)
                        Return
                    End If

                Else
                End If
            End If
        End Sub

    End Class
End Namespace