'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnJump.vb                                               --
'--                                                                           --
'--  Author(s)     :  Chen Qinghua (Three Swordsmen Team)                     --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.Search                                     --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWCCore.Document
Imports WomenWCCore.Infos.SearchEngine
Imports WomenWC.Dialogues
Imports WomenWC.Managers.Manager

Namespace Menu.Search
    Public Class OnJump
        Inherits MenuItemProcessBase

        Private _jumpDialog As JumpDialog
        Private Const STR_COMMENT As String = "w肵sԍփJ[\ړ"


        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
            _jumpDialog = New JumpDialog
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                If DocumentFormManager.CurrentDocumentForm IsNot Nothing Then
                    Return True
                Else
                    Return False
                End If
            End Get
        End Property

        Public Overrides Sub Execute()
            Dim intTargetLine As Integer
            Dim currentDocForm As DocumentForm
            Dim currentDoc As Document

            currentDocForm = DocumentFormManager.CurrentDocumentForm
            If currentDocForm IsNot Nothing AndAlso _jumpDialog.ShowDialog() = DialogResult.OK Then
                currentDoc = currentDocForm.Document
                intTargetLine = _jumpDialog.LineNo - 1
                If intTargetLine > currentDoc.DocumentLinesCount - 1 Then
                    intTargetLine = currentDoc.DocumentLinesCount - 1
                ElseIf intTargetLine < 0 Then
                    intTargetLine = 0
                End If
                currentDocForm.WomenWCEditor.CaretMoveTo(intTargetLine, 0)
            Else
            End If
        End Sub

    End Class
End Namespace
