'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnWindowList.vb                                         --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.Window                                     --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Infos.Menu
Imports WomenWCCore.Interfaces.Menu
Imports WomenWC.Forms
Imports WomenWC.Managers.Manager

Namespace Menu.Window
    Public Class OnWindowList
        Inherits MenuItemProcessBase

        Private Const STR_COMMENT As String = "SĂ̊JEBhEꗗ\"

        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm)
            MyBase.New(womenWCMainForm)
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides ReadOnly Property IsEnable() As Boolean
            Get
                If DocumentFormManager.DocumentForms.Count > 0 Then
                    Return True
                Else
                    Return False
                End If
            End Get
        End Property

        Public Overrides ReadOnly Property HasDynamicMenuItem() As Boolean
            Get
                Return True
            End Get
        End Property

        Public Overrides ReadOnly Property DynamicMenuItemInfos() As System.Collections.Generic.List(Of WomenWCCore.Infos.Menu.DynamicMenuItemInfo)
            Get
                Dim result As List(Of DynamicMenuItemInfo)
                Dim toolStripMenuItem As ToolStripMenuItem
                Dim menuItemProcess As IMenuItemProcess
                Dim documentFileName As String

                result = New List(Of DynamicMenuItemInfo)
                For Each documentForm As DocumentForm In DocumentFormManager.DocumentForms
                    documentFileName = documentForm.Document.DocumentFileName
                    toolStripMenuItem = New ToolStripMenuItem(documentFileName)
                    menuItemProcess = New OnWindowListSubItem(WomenWCMainForm, documentFileName)
                    result.Add(New DynamicMenuItemInfo(toolStripMenuItem, menuItemProcess))
                Next
                Return result
            End Get
        End Property

        Public Overrides Sub Execute()

        End Sub

    End Class
End Namespace
