'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  OnWindowListSubItem.vb                                  --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWC.Menu.Window                                     --
'--                                                                           --
'--  Project       :  WomenWC                                                 --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWC.Forms
Imports WomenWC.Managers.Manager

Namespace Menu.Window
    Public Class OnWindowListSubItem
        Inherits MenuItemProcessBase

        Private _documentFileName As String
        Private Const STR_COMMENT As String = "w̃EBhE\"


        Public Sub New(ByVal womenWCMainForm As WomenWCMainForm, ByVal documentFileName As String)
            MyBase.New(womenWCMainForm)
            _documentFileName = documentFileName
        End Sub

        Public Overrides ReadOnly Property Comment() As String
            Get
                Return STR_COMMENT
            End Get
        End Property

        Public Overrides Sub Execute()
            DocumentFormManager.ActivateDocumentForm(_documentFileName, FormWindowState.Maximized)
        End Sub

    End Class

End Namespace
