'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  ShowInItemAttribute.vb                                  --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWCCore.Attributes                                  --
'--                                                                           --
'--  Project       :  WomenWCCore                                             --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Namespace Attributes
    <AttributeUsage(AttributeTargets.Property)> _
    Public Class ShowInItemAttribute
        Inherits Attribute

        Private _isShow As Boolean

        Public Sub New(ByVal isShow As Boolean)
            _isShow = isShow
        End Sub

        Public ReadOnly Property IsShow() As Boolean
            Get
                Return _isShow
            End Get
        End Property

    End Class
End Namespace
