'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  NeedUpdateMemberEventArgs.vb                            --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWCCore.EventArgs                                   --
'--                                                                           --
'--  Project       :  WomenWCCore                                             --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Document
Namespace EventArgs
    Public Class NeedUpdateMemberEventArgs
        Inherits System.EventArgs

        Private _currentPosition As Position

        Public Sub New(ByVal currentPosition As Position)
            _currentPosition = currentPosition
        End Sub

        Public Sub New()
            Me.New(New Position(0, 0))
        End Sub

        Public Property currentPosition() As Position
            Get
                Return _currentPosition
            End Get
            Set(ByVal value As Position)
                _currentPosition = value
            End Set
        End Property

    End Class
End Namespace
