'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  FunctionInfo.vb                                         --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWCCore.Infos.Analyzer                              --
'--                                                                           --
'--  Project       :  WomenWCCore                                             --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports WomenWCCore.Attributes
Imports WomenWCCore.Interfaces.Info
Imports WomenWCCore.Document
Namespace Infos.Analyzer
    Public Class FunctionInfo
        Implements IMoveable

        Private Const ITEMNAME_NAME As String = "֐"
        Private Const ITEMNAME_FILENAME As String = "t@C"
        Private Const ITEMNAME_LOCATION As String = "ʒu"
        Private Const ITEMNAME_PARENT As String = "Wc"
        Private Const ITEMNAME_DECLARE As String = "`"

        Private _functionName As String
        Private _functionFileName As String
        Private _functionLocation As Integer
        Private _functionParent As String
        Private _functionDeclare As String

        Public Sub New(ByVal functionName As String, ByVal functionFileName As String, ByVal funcitonLocation As Integer, ByVal functionParent As String, ByVal functionDeclare As String)
            _functionName = functionName
            _functionFileName = functionFileName
            _functionLocation = funcitonLocation
            _functionParent = functionParent
            _functionDeclare = functionDeclare
        End Sub

        Public Sub New()
            Me.New(String.Empty, String.Empty, -1, String.Empty, String.Empty)
        End Sub

        <ShowInItem(True), ItemName(ITEMNAME_NAME)> _
        Public Property FunctionName() As String
            Get
                Return _functionName
            End Get
            Set(ByVal value As String)
                _functionName = value
            End Set
        End Property

        <ShowInItem(True), ItemName(ITEMNAME_FILENAME)> _
        Public Property FunctionFileName() As String
            Get
                Return _functionFileName
            End Get
            Set(ByVal value As String)
                _functionFileName = value
            End Set
        End Property

        <ShowInItem(True), ItemName(ITEMNAME_LOCATION)> _
        Public Property FunctionLocation() As Integer
            Get
                Return _functionLocation
            End Get
            Set(ByVal value As Integer)
                _functionLocation = value
            End Set
        End Property

        <ShowInItem(True), ItemName(ITEMNAME_PARENT)> _
            Public Property FunctionParent() As String
            Get
                Return _functionParent
            End Get
            Set(ByVal value As String)
                _functionParent = value
            End Set
        End Property

        <ShowInDescription(True), ItemName(ITEMNAME_DECLARE)> _
        Public Property FunctionDeclare() As String
            Get
                Return _functionDeclare
            End Get
            Set(ByVal value As String)
                _functionDeclare = value
            End Set
        End Property

        Public ReadOnly Property MoveFileName() As String Implements IMoveable.FileName
            Get
                Return FunctionFileName
            End Get
        End Property

        Public ReadOnly Property MovePosition() As Position Implements IMoveable.Position
            Get
                Return New Position(FunctionLocation, 0)
            End Get
        End Property

    End Class
End Namespace
