'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  DynamicMenuItemInfo.vb                                  --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWCCore.Infos.Menu                                  --
'--                                                                           --
'--  Project       :  WomenWCCore                                             --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports System.Windows.Forms
Imports WomenWCCore.Interfaces.Menu
Namespace Infos.Menu
    Public Class DynamicMenuItemInfo

        Private _toolStripMenuItem As ToolStripMenuItem
        Private _menuItemProcess As IMenuItemProcess

        Public Sub New(ByVal toolStripMenuItem As ToolStripMenuItem, ByVal menuItemProcess As IMenuItemProcess)
            _toolStripMenuItem = toolStripMenuItem
            _menuItemProcess = menuItemProcess
        End Sub

        Public Sub New()
            Me.New(Nothing, Nothing)
        End Sub

        Public Property ToolStripMenuItem() As ToolStripMenuItem
            Get
                Return _toolStripMenuItem
            End Get
            Set(ByVal value As ToolStripMenuItem)
                _toolStripMenuItem = value
            End Set
        End Property

        Public Property MenuItemProcess() As IMenuItemProcess
            Get
                Return _menuItemProcess
            End Get
            Set(ByVal value As IMenuItemProcess)
                _menuItemProcess = value
            End Set
        End Property

    End Class
End Namespace
