'-------------------------------------------------------------------------------
'--                                                                           --
'--  FILE          :  IWomenWCEditor.vb                                       --
'--                                                                           --
'--  Author(s)     :  Yin Xuebin (Three Swordsmen Team)                       --
'--                                                                           --
'--  NameSpace     :  WomenWCCore.Interfaces.Editor                           --
'--                                                                           --
'--  Project       :  WomenWCCore                                             --
'--                                                                           --
'--  Solution      :  Women Working with COBOL                                --
'--                                                                           --
'--  Creation Date :  2007/04/10                                              --
'-------------------------------------------------------------------------------
'--  Modifications :                                                          --
'--                                                                           --
'--                                                                           --
'--                                                                           --
'-------------------------------------------------------------------------------
'-- Copyright(C) 2007, Three Swordsmen, Beijing China                         --
'--                                                                           --
'-- This software is released under the GNU General Public License            --
'-------------------------------------------------------------------------------

Imports System.Windows.Forms
Imports System.Drawing
Imports WomenWCCore.EventArgs
Imports WomenWCCore.Document
Imports WomenWCCore.Enums
Imports WomenWCCore.Interfaces.Analyzer

Namespace Interfaces.Editor
    Public Interface IWomenWCEditor

#Region "Events"

        Event CaretPositionChanged(ByVal sender As Object, ByVal e As CaretPositionChangedEventArgs)
        Event CaretPositionGoTo(ByVal sender As Object, ByVal e As CaretPositionGoToEventArgs)
        Event CaretStatusChanged(ByVal sender As Object, ByVal e As CaretStatusChangedEventArgs)
        Event MouseStopAtWord(ByVal sender As Object, ByVal e As MouseStopAtWordEventArgs)
        Event NeedUpdateMember(ByVal sender As Object, ByVal e As NeedUpdateMemberEventArgs)

#End Region

#Region "Properties"

        ReadOnly Property CaretPhysicalPosition() As Position
        ReadOnly Property CaretStatus() As CaretStatusEnum
        ReadOnly Property CanUndo() As Boolean
        ReadOnly Property CanRedo() As Boolean
        Property FontColor() As Dictionary(Of WordTypeEnum, Color)
        Property Document() As Document.Document
        Property WomenWCAnalyzer() As IWomenWCAnalyzer        

#End Region

#Region "Usercontrol Properties"

        Property Font() As Font
        Property Dock() As DockStyle
        Property Location() As Point

#End Region

#Region "About Caret"

        Sub CaretMoveTo(ByVal row As Integer, ByVal col As Integer, Optional ByVal sendEvent As Boolean = True)
        Function Focus() As Boolean

#End Region

#Region "About Selection"

        Sub SetSelection(ByVal selectionStart As Position, ByVal selectionEnd As Position)
        Sub SelectAll()
        Sub Copy()
        Sub Cut()
        Sub Paste()

#End Region

#Region "About BookMark"

        Sub SetBookMark(ByVal row As Integer, ByVal bookMark As Boolean)

#End Region

#Region "About Edit"

        Sub CommentOut()
        Sub CommentCancel()
        Sub EditText(ByVal text As String)
        Sub Redo()
        Sub Undo()
        Function DeleteText(ByVal length As Integer) As String

#End Region

#Region "Others"

        Sub Initialize(ByVal document As Document.Document, ByVal womenWCAnalyzer As IWomenWCAnalyzer, ByVal fontColor As Dictionary(Of WordTypeEnum, Color))
        Sub InitializeCodeListView(ByVal codeCompletionListType As CodeCompletionListTypeEnum, ByVal keyWords As List(Of String), ByVal functionList As List(Of String), ByVal variableList As List(Of String))
        Sub Refresh()
        Sub ShowCommentTip(ByVal comment As String, ByVal position As Point, ByVal duration As Integer)
        Sub HideCommentTip()
        Sub SetContextMenuStrip(ByVal contextMenuStrip As ContextMenuStrip)
        Function Print(ByVal fromDocumentLine As Integer, ByVal graphics As Graphics, ByVal printRectangle As Rectangle) As Integer

#End Region

    End Interface
End Namespace
