/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.util.Collection;
import org.w3c.dom.Element;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.el.GettingEL;
import woolpack.utils.UtilsConstants;

public class EqualsAttrValue
implements DomExpression {
    private final String attrName;
    private final GettingEL valueEL;
    private final DomExpression trueExpression;
    private final DomExpression falseExpression;

    public EqualsAttrValue(String attrName, GettingEL valueEL, DomExpression trueExpression) {
        this(attrName, valueEL, trueExpression, DomConstants.NULL);
    }

    public EqualsAttrValue(String attrName, GettingEL valueEL, DomExpression trueExpression, DomExpression falseExpression) {
        attrName.charAt(0);
        valueEL.getClass();
        trueExpression.getClass();
        falseExpression.getClass();
        this.attrName = attrName;
        this.valueEL = valueEL;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    public void interpret(DomContext context) {
        Object value = this.valueEL.getValue(context);
        Collection collection = UtilsConstants.toCollection(value);
        String elementValue = ((Element)context.getNode()).getAttribute(this.attrName);
        boolean containsFlag = false;
        for (Object o : collection) {
            if (o == null || !o.toString().equals(elementValue)) continue;
            containsFlag = true;
            break;
        }
        if (containsFlag) {
            this.trueExpression.interpret(context);
        } else {
            this.falseExpression.interpret(context);
        }
    }
}

