/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.Collection;

/**
 * 機能を逸脱するエラーが発生した場合にコンテキストのダンプ情報を付加した{@link RuntimeException}でラップして委譲元に例外を投げる{@link ValidatorExpression}。
 * @author nakamura
 *
 */
public class DumpValidator implements ValidatorExpression {
	private final ValidatorExpression expression;
	
	/**
	 * コンストラクタ。
	 * @param expression 委譲先。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public DumpValidator(final ValidatorExpression expression){
		expression.getClass();
		this.expression = expression;
	}

	public boolean interpret(final ValidatorContext context) {
		try{
			return expression.interpret(context);
		}catch(final RuntimeException e){
			final StringBuilder sb = new StringBuilder();
			try {
				context.appendTo(sb);
			} catch (IOException e1) {
				sb.append(e1);
			}
			throw new RuntimeException(sb.toString(), e);
		}
	}

	public void appendTo(final Appendable sb) throws IOException {
		expression.appendTo(sb);
	}

	public void addMessageTo(final Collection<String> messageCollection) {
		expression.addMessageTo(messageCollection);
	}

}
