/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.Collection;

/**
 * メッセージを追加する{@link ValidatorExpression}。
 * @author nakamura
 *
 */
public class MessageValidator extends ValidatorExpressionAdapter {
	private final String message;
	
	/**
	 * コンストラクタ。
	 * @param message メッセージ。
	 * @throws NullPointerException 引数が null の場合。
	 * @throws StringIndexOutOfBoundsException message が空の場合。
	 */
	public MessageValidator(final String message){
		message.charAt(0);
		this.message = message;
	}

	/**
	 * @throws NullPointerException 引数が null の場合。
	 */
	@Override public boolean interpret(final ValidatorContext context) {
		context.add(message);
		return false;
	}

	@Override public void appendArgumentTo(final Appendable sb) throws IOException{
		ValidatorConstants.appendTo(sb, message);
	}


	@Override public void addMessageTo(final Collection<String> messageCollection) {
		messageCollection.add(message);
	}
}
