/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.regex.Pattern;

/**
 * 正規表現を使用して{@link ValidatorContext#getId()}を検証してその結果を返す{@link ValidatorExpression}。
 * {@link ValidatorContext}に対して状態を変更する操作を行わない。
 * @author nakamura
 *
 */
public class RegExpIdValidator extends ValidatorExpressionAdapter {
	private final Pattern pattern;
	
	/**
	 * コンストラクタ。
	 * @param pattern 正規表現。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public RegExpIdValidator(final Pattern pattern){
		pattern.getClass();
		this.pattern = pattern;
	}

	/**
	 * コンストラクタ。
	 * @param pattern 正規表現。
	 * @throws NullPointerException 引数が null の場合。
	 * @throws PatternSyntaxException 表現の構文が無効である場合。
	 */
	public RegExpIdValidator(final String pattern){
		this(Pattern.compile(pattern));
	}

	/**
	 * @throws NullPointerException 引数または{@link ValidatorContext#getId()}が null の場合。
	 */
	public boolean interpret(final ValidatorContext context) {
		return pattern.matcher(context.getId()).matches();
	}

	@Override public void appendArgumentTo(final Appendable sb) throws IOException{
		ValidatorConstants.appendTo(sb, pattern);
	}
}
